/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.util.Comparators;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanComparator;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mCursor;
    private final SortBuffer<S> mChunkBuffer;
    private final Comparator<S> mChunkMatcher;
    private final Comparator<S> mChunkSorter;
    private Iterator<S> mChunkIterator;
    private S mNextChunkStart;

    public static <S> Comparator<S> createComparator(Class<S> type, String ... orderProperties) {
        BeanComparator bc = BeanComparator.forClass(type);
        if (Storable.class.isAssignableFrom(type)) {
            StorableInfo<S> info = StorableIntrospector.examine(type);
            for (String property : orderProperties) {
                bc = SortedCursor.orderBy(bc, OrderedProperty.parse(info, property));
            }
        } else {
            for (String property : orderProperties) {
                String name = property;
                if (name.startsWith("+") || name.startsWith("-")) {
                    name = name.substring(1);
                }
                Class propertyType = SortedCursor.propertyType(type, name);
                bc = SortedCursor.orderBy(bc, property, propertyType, Direction.ASCENDING);
            }
        }
        return bc;
    }

    private static Class propertyType(Class enclosingType, String propertyName) {
        Map properties = BeanIntrospector.getAllProperties((Class)enclosingType);
        int dotIndex = propertyName.indexOf(46);
        if (dotIndex < 0) {
            BeanProperty bp = (BeanProperty)properties.get(propertyName);
            return bp == null ? null : bp.getType();
        }
        String parentName = propertyName.substring(0, dotIndex);
        BeanProperty bp = (BeanProperty)properties.get(parentName);
        if (bp == null) {
            return null;
        }
        return SortedCursor.propertyType(bp.getType(), propertyName.substring(dotIndex + 1));
    }

    public static <S extends Storable> Comparator<S> createComparator(OrderedProperty<S> ... properties) {
        if (properties == null || properties.length == 0 || properties[0] == null) {
            throw new IllegalArgumentException();
        }
        Class<S> type = properties[0].getChainedProperty().getPrimeProperty().getEnclosingType();
        BeanComparator bc = BeanComparator.forClass(type);
        for (OrderedProperty<S> property : properties) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            bc = SortedCursor.orderBy(bc, property);
        }
        return bc;
    }

    public static <S extends Storable> Comparator<S> createComparator(List<OrderedProperty<S>> properties) {
        if (properties == null || properties.size() == 0 || properties.get(0) == null) {
            throw new IllegalArgumentException();
        }
        Class<S> type = properties.get(0).getChainedProperty().getPrimeProperty().getEnclosingType();
        BeanComparator bc = BeanComparator.forClass(type);
        for (OrderedProperty<S> property : properties) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            bc = SortedCursor.orderBy(bc, property);
        }
        return bc;
    }

    private static BeanComparator orderBy(BeanComparator bc, OrderedProperty property) {
        ChainedProperty chained = property.getChainedProperty();
        return SortedCursor.orderBy(bc, SortedCursor.chainToBeanString(chained), chained.getType(), property.getDirection());
    }

    private static BeanComparator orderBy(BeanComparator bc, String property, Class type, Direction direction) {
        bc = bc.orderBy(property);
        if (type != null && type.isArray()) {
            TypeDesc td = TypeDesc.forClass((Class)type);
            if (td.getRootComponentType() == TypeDesc.BYTE) {
                bc = bc.using(Comparators.arrayComparator(type, true));
            } else {
                Comparator c = Comparators.arrayComparator(type, false);
                if (c == null) {
                    throw new IllegalArgumentException("Cannot sort by property type of " + type.getName() + " for " + property);
                }
                bc = bc.using(c);
            }
        } else {
            bc = bc.caseSensitive();
        }
        if (direction == Direction.DESCENDING) {
            bc = bc.reverse();
        }
        return bc;
    }

    private static String chainToBeanString(ChainedProperty property) {
        int count = property.getChainCount();
        if (count <= 0) {
            return property.getPrimeProperty().getBeanName();
        }
        StringBuilder b = new StringBuilder();
        b.append(property.getPrimeProperty().getBeanName());
        for (int i = 0; i < count; ++i) {
            b.append('.');
            b.append(property.getChainedProperty(i).getBeanName());
        }
        return b.toString();
    }

    public SortedCursor(Cursor<S> cursor, SortBuffer<S> buffer, Comparator<S> handled, Comparator<S> finisher) {
        if (cursor == null || finisher == null) {
            throw new IllegalArgumentException();
        }
        this.mCursor = cursor;
        this.mChunkBuffer = buffer;
        this.mChunkMatcher = handled;
        this.mChunkSorter = finisher;
    }

    public SortedCursor(Cursor<S> cursor, SortBuffer<S> buffer, Class<S> type, String ... orderProperties) {
        this(cursor, buffer, null, SortedCursor.createComparator(type, orderProperties));
    }

    public Comparator<S> comparator() {
        if (this.mChunkMatcher == null) {
            return this.mChunkSorter;
        }
        return new Comparator<S>(){

            @Override
            public int compare(S a, S b) {
                int result = SortedCursor.this.mChunkMatcher.compare(a, b);
                if (result == 0) {
                    result = SortedCursor.this.mChunkSorter.compare(a, b);
                }
                return result;
            }
        };
    }

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
        this.mChunkIterator = null;
        this.mChunkBuffer.close();
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            this.prepareNextChunk();
            try {
                if (this.mChunkIterator.hasNext()) {
                    return true;
                }
            }
            catch (UndeclaredThrowableException e) {
                throw this.toFetchException(e);
            }
        }
        catch (NoSuchElementException e) {
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.close();
        return false;
    }

    @Override
    public S next() throws FetchException {
        try {
            this.prepareNextChunk();
            try {
                return this.mChunkIterator.next();
            }
            catch (UndeclaredThrowableException e) {
                throw this.toFetchException(e);
            }
            catch (NoSuchElementException e) {
                try {
                    this.close();
                }
                catch (FetchException e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (--amount >= 0 && this.hasNext()) {
                this.next();
                ++count;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void prepareNextChunk() throws FetchException {
        if (this.mChunkIterator != null && (this.mChunkMatcher == null || this.mChunkIterator.hasNext())) {
            return;
        }
        Cursor<S> cursor = this.mCursor;
        SortBuffer<S> buffer = this.mChunkBuffer;
        Comparator<S> matcher = this.mChunkMatcher;
        try {
            block11: {
                S chunkStart;
                block14: {
                    block13: {
                        block12: {
                            this.mChunkIterator = null;
                            buffer.prepare(this.mChunkSorter);
                            if (matcher != null) break block12;
                            int count = 0;
                            while (cursor.hasNext()) {
                                if ((++count & 0xFFFFFF00) == 0 && Thread.interrupted()) {
                                    throw new FetchInterruptedException();
                                }
                                buffer.add(cursor.next());
                            }
                            break block11;
                        }
                        if (this.mNextChunkStart == null) break block13;
                        chunkStart = this.mNextChunkStart;
                        this.mNextChunkStart = null;
                        break block14;
                    }
                    if (!cursor.hasNext()) break block11;
                    chunkStart = cursor.next();
                }
                buffer.add(chunkStart);
                int count = 1;
                while (cursor.hasNext()) {
                    if ((++count & 0xFFFFFF00) == 0 && Thread.interrupted()) {
                        throw new FetchInterruptedException();
                    }
                    S next = cursor.next();
                    if (matcher.compare(chunkStart, next) != 0) {
                        this.mNextChunkStart = next;
                        break;
                    }
                    buffer.add(next);
                }
            }
            if (buffer.size() > 1) {
                buffer.sort();
            }
            this.mChunkIterator = buffer.iterator();
        }
        catch (UndeclaredThrowableException e) {
            throw this.toFetchException(e);
        }
    }

    private FetchException toFetchException(UndeclaredThrowableException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        if (cause instanceof FetchException) {
            return (FetchException)cause;
        }
        return new FetchException(null, cause);
    }
}

