/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonCursor<S>
implements Cursor<S> {
    private volatile S mObject;

    public SingletonCursor(S object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.mObject = object;
    }

    @Override
    public void close() {
        this.mObject = null;
    }

    @Override
    public boolean hasNext() {
        return this.mObject != null;
    }

    @Override
    public S next() {
        S object = this.mObject;
        this.mObject = null;
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    @Override
    public int skipNext(int amount) {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        S object = this.mObject;
        this.mObject = null;
        return object == null ? 0 : 1;
    }

    @Override
    public int copyInto(Collection<? super S> c) {
        S object = this.mObject;
        this.mObject = null;
        if (object == null) {
            return 0;
        }
        c.add(object);
        return 1;
    }

    @Override
    public int copyInto(Collection<? super S> c, int limit) {
        return limit <= 0 ? 0 : this.copyInto(c);
    }

    @Override
    public List<S> toList() {
        ArrayList list = new ArrayList(1);
        this.copyInto(list);
        return list;
    }

    @Override
    public List<S> toList(int limit) {
        ArrayList list = new ArrayList(1);
        this.copyInto(list, limit);
        return list;
    }
}

