/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ClosedFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OpenFilter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShortCircuitOptimizer {
    ShortCircuitOptimizer() {
    }

    public static <S extends Storable> Filter<S> optimize(Filter<S> filter) {
        return ((FilterAndCost)filter.accept(new Walker<S>(), null)).mNewFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Walker<S extends Storable>
    extends Visitor<S, FilterAndCost<S>, Object> {
        private Walker() {
        }

        @Override
        public FilterAndCost<S> visit(OrFilter<S> filter, Object param) {
            ChainedProperty expensiveProperty;
            Filter newFilter;
            FilterAndCost rightCost;
            FilterAndCost leftCost = (FilterAndCost)filter.getLeftFilter().accept(this, param);
            int compare = leftCost.compareCost(rightCost = (FilterAndCost)filter.getRightFilter().accept(this, param));
            if (compare <= 0) {
                newFilter = leftCost.mNewFilter.or(rightCost.mNewFilter);
                expensiveProperty = rightCost.mExpensiveProperty;
            } else {
                newFilter = rightCost.mNewFilter.or(leftCost.mNewFilter);
                expensiveProperty = leftCost.mExpensiveProperty;
            }
            return new FilterAndCost(newFilter, expensiveProperty);
        }

        @Override
        public FilterAndCost<S> visit(AndFilter<S> filter, Object param) {
            ChainedProperty expensiveProperty;
            Filter newFilter;
            FilterAndCost rightCost;
            FilterAndCost leftCost = (FilterAndCost)filter.getLeftFilter().accept(this, param);
            int compare = leftCost.compareCost(rightCost = (FilterAndCost)filter.getRightFilter().accept(this, param));
            if (compare <= 0) {
                newFilter = leftCost.mNewFilter.and(rightCost.mNewFilter);
                expensiveProperty = rightCost.mExpensiveProperty;
            } else {
                newFilter = rightCost.mNewFilter.and(leftCost.mNewFilter);
                expensiveProperty = leftCost.mExpensiveProperty;
            }
            return new FilterAndCost(newFilter, expensiveProperty);
        }

        @Override
        public FilterAndCost<S> visit(PropertyFilter<S> filter, Object param) {
            return new FilterAndCost<S>(filter, filter.getChainedProperty());
        }

        @Override
        public FilterAndCost<S> visit(ExistsFilter<S> filter, Object param) {
            return new FilterAndCost<S>(filter, filter.getChainedProperty());
        }

        @Override
        public FilterAndCost<S> visit(OpenFilter<S> filter, Object param) {
            return new FilterAndCost<S>(filter, null);
        }

        @Override
        public FilterAndCost<S> visit(ClosedFilter<S> filter, Object param) {
            return new FilterAndCost<S>(filter, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterAndCost<S extends Storable> {
        final Filter<S> mNewFilter;
        final ChainedProperty<S> mExpensiveProperty;

        FilterAndCost(Filter<S> filter, ChainedProperty<S> expensive) {
            this.mNewFilter = filter;
            this.mExpensiveProperty = expensive;
        }

        int compareCost(FilterAndCost<S> other) {
            if (this.mExpensiveProperty == null) {
                if (other.mExpensiveProperty == null) {
                    return 0;
                }
                return -1;
            }
            if (other.mExpensiveProperty == null) {
                return 1;
            }
            if (this.mExpensiveProperty.equals(other.mExpensiveProperty)) {
                return 0;
            }
            int result = this.joinCompare(this.mExpensiveProperty.getPrimeProperty(), other.mExpensiveProperty.getPrimeProperty());
            if (result != 0) {
                return result;
            }
            if (this.mExpensiveProperty.getChainCount() == 0) {
                if (other.mExpensiveProperty.getChainCount() == 0) {
                    return 0;
                }
            } else if (other.mExpensiveProperty.getChainCount() == 0) {
                return 1;
            }
            int length = Math.min(this.mExpensiveProperty.getChainCount(), other.mExpensiveProperty.getChainCount());
            for (int i = 0; i < length; ++i) {
                result = this.joinCompare(this.mExpensiveProperty.getChainedProperty(i), other.mExpensiveProperty.getChainedProperty(i));
                if (result == 0) continue;
                return result;
            }
            if (this.mExpensiveProperty.getChainCount() < other.mExpensiveProperty.getChainCount()) {
                return -1;
            }
            if (this.mExpensiveProperty.getChainCount() > other.mExpensiveProperty.getChainCount()) {
                return 1;
            }
            return 0;
        }

        private int joinCompare(StorableProperty<?> a, StorableProperty<?> b) {
            if (a.isQuery()) {
                if (b.isQuery()) {
                    return 0;
                }
                return 1;
            }
            if (b.isQuery()) {
                return -1;
            }
            if (a.isJoin()) {
                if (b.isJoin()) {
                    return 0;
                }
                return 1;
            }
            if (b.isJoin()) {
                return -1;
            }
            return 0;
        }
    }
}

