/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.cursor.WorkFilePool;
import com.amazon.carbonado.spi.RAFInputStream;
import com.amazon.carbonado.spi.RAFOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSortBuffer<S extends Storable>
extends AbstractCollection<S>
implements SortBuffer<S> {
    private static final int MIN_ARRAY_CAPACITY = 64;
    private static final int MAX_ARRAY_CAPACITY;
    private static final int DEFAULT_MAX_ARRAY_CAPACITY = 8192;
    private static final int MAX_OPEN_FILE_COUNT;
    private static final int DEFAULT_MAX_OPEN_FILE_COUNT = 100;
    private static final int OUTPUT_BUFFER_SIZE;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 10000;
    private static final String TEMP_DIR;
    private final String mTempDir;
    private final int mMaxArrayCapacity;
    private Preparer<S> mPreparer;
    private S[] mElements;
    private int mSize;
    private int mTotalSize;
    private WorkFilePool mWorkFilePool;
    private List<RandomAccessFile> mFilesInUse;
    private Comparator<S> mComparator;
    private volatile boolean mStop;

    public MergeSortBuffer() {
        this(null, TEMP_DIR, MAX_ARRAY_CAPACITY);
    }

    public MergeSortBuffer(Storage<S> storage) {
        this(storage, TEMP_DIR, MAX_ARRAY_CAPACITY);
    }

    public MergeSortBuffer(Storage<S> storage, String tempDir) {
        this(storage, tempDir, MAX_ARRAY_CAPACITY);
    }

    public MergeSortBuffer(Storage<S> storage, String tempDir, int maxArrayCapacity) {
        this.mTempDir = tempDir;
        this.mMaxArrayCapacity = maxArrayCapacity;
        if (storage != null) {
            this.mPreparer = new FromStorage<S>(storage);
        }
        int cap = Math.min(64, maxArrayCapacity);
        this.mElements = new Storable[cap];
    }

    @Override
    public void prepare(Comparator<S> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException();
        }
        this.clear();
        this.mComparator = comparator;
    }

    @Override
    public boolean add(S storable) {
        if (this.mPreparer == null) {
            this.mPreparer = new FromStorable<S>(storable);
        }
        Comparator<S> comparator = this.comparator();
        if (this.mSize >= this.mElements.length) {
            if (this.mElements.length < this.mMaxArrayCapacity) {
                int newCap = this.mElements.length * 2;
                if (newCap > this.mMaxArrayCapacity) {
                    newCap = this.mMaxArrayCapacity;
                }
                Storable[] newElements = new Storable[newCap];
                System.arraycopy(this.mElements, 0, newElements, 0, this.mElements.length);
                this.mElements = newElements;
            } else {
                if (this.mWorkFilePool == null) {
                    this.mWorkFilePool = WorkFilePool.getInstance(this.mTempDir);
                    this.mFilesInUse = new ArrayList<RandomAccessFile>();
                }
                Arrays.sort(this.mElements, comparator);
                try {
                    RandomAccessFile raf = this.mWorkFilePool.acquireWorkFile(this);
                    BufferedOutputStream out = new BufferedOutputStream(new RAFOutputStream(raf), OUTPUT_BUFFER_SIZE);
                    if (this.mFilesInUse.size() < MAX_OPEN_FILE_COUNT - 1) {
                        this.mFilesInUse.add(raf);
                        int count = 0;
                        for (S element : this.mElements) {
                            this.interruptCheck(++count);
                            element.writeTo(out);
                        }
                    } else {
                        long totalLength = 0L;
                        int fileCount = this.mFilesInUse.size();
                        for (int i = 0; i < fileCount; ++i) {
                            totalLength += this.mFilesInUse.get(i).length();
                        }
                        long averageLength = (totalLength + (long)fileCount) / (long)fileCount;
                        ArrayList<RandomAccessFile> filesToExclude = new ArrayList<RandomAccessFile>();
                        ArrayList<RandomAccessFile> filesToMerge = new ArrayList<RandomAccessFile>();
                        long mergedLength = 0L;
                        for (int i = 0; i < fileCount; ++i) {
                            RandomAccessFile fileInUse = this.mFilesInUse.get(i);
                            long fileLength = fileInUse.length();
                            if (fileLength > averageLength) {
                                filesToExclude.add(fileInUse);
                                continue;
                            }
                            filesToMerge.add(fileInUse);
                            mergedLength += fileLength;
                        }
                        this.mFilesInUse.add(raf);
                        raf.setLength(mergedLength);
                        int count = 0;
                        Iterator<S> it = this.iterator(filesToMerge);
                        while (it.hasNext()) {
                            this.interruptCheck(++count);
                            Storable element = (Storable)it.next();
                            element.writeTo(out);
                        }
                        this.mWorkFilePool.releaseWorkFiles(filesToMerge);
                        this.mFilesInUse = filesToExclude;
                        this.mFilesInUse.add(raf);
                    }
                    ((OutputStream)out).flush();
                    raf.setLength(raf.getFilePointer());
                    raf.seek(0L);
                }
                catch (SupportException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (IOException e) {
                    throw new UndeclaredThrowableException(e);
                }
                this.mSize = 0;
            }
        }
        this.mElements[this.mSize++] = storable;
        ++this.mTotalSize;
        return true;
    }

    @Override
    public int size() {
        return this.mTotalSize;
    }

    @Override
    public Iterator<S> iterator() {
        return this.iterator(this.mFilesInUse);
    }

    private Iterator<S> iterator(List<RandomAccessFile> filesToMerge) {
        Comparator<S> comparator = this.comparator();
        if (this.mWorkFilePool == null) {
            return new ObjectArrayIterator<S>(this.mElements, 0, this.mSize);
        }
        PriorityQueue pq = new PriorityQueue(1 + this.mFilesInUse.size());
        pq.add(new ArrayIter(comparator, this.mElements, this.mSize));
        for (RandomAccessFile raf : filesToMerge) {
            try {
                raf.seek(0L);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
            BufferedInputStream in = new BufferedInputStream(new RAFInputStream(raf));
            pq.add(new InputIter<S>(comparator, this.mPreparer, in));
        }
        return new Merger(pq);
    }

    @Override
    public void clear() {
        if (this.mPreparer instanceof FromStorable) {
            this.mPreparer = null;
        }
        if (this.mTotalSize > 0) {
            this.mSize = 0;
            this.mTotalSize = 0;
            if (this.mWorkFilePool != null && this.mFilesInUse != null) {
                this.mWorkFilePool.releaseWorkFiles(this.mFilesInUse);
                this.mFilesInUse.clear();
            }
        }
    }

    @Override
    public void sort() {
        Arrays.sort(this.mElements, 0, this.mSize, this.comparator());
    }

    @Override
    public void close() {
        this.clear();
        if (this.mWorkFilePool != null) {
            this.mWorkFilePool.unregisterWorkFileUser(this);
        }
    }

    void stop() {
        this.mStop = true;
    }

    private Comparator<S> comparator() {
        Comparator<S> comparator = this.mComparator;
        if (comparator == null) {
            throw new IllegalStateException("Buffer was not prepared with a Comparator");
        }
        return comparator;
    }

    private void interruptCheck(int count) {
        if ((count & 0xFFFFFF00) == 0 && (this.mStop || Thread.interrupted())) {
            this.close();
            throw new UndeclaredThrowableException(new FetchInterruptedException());
        }
    }

    static {
        File f;
        String prefix = MergeSortBuffer.class.getName() + '.';
        MAX_ARRAY_CAPACITY = Integer.getInteger(prefix + "maxArrayCapacity", 8192);
        MAX_OPEN_FILE_COUNT = Integer.getInteger(prefix + "maxOpenFileCount", 100);
        OUTPUT_BUFFER_SIZE = Integer.getInteger(prefix + "outputBufferSize", 10000);
        String tempDir = System.getProperty(prefix + "tmpdir", null);
        if (!(tempDir == null || (f = new File(tempDir)).exists() && f.isDirectory() && f.canRead() && f.canWrite())) {
            tempDir = null;
        }
        TEMP_DIR = tempDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArrayIterator<E>
    implements Iterator<E> {
        private final E[] mElements;
        private final int mEnd;
        private int mIndex;

        public ObjectArrayIterator(E[] elements, int start, int end) {
            this.mElements = elements;
            this.mEnd = end;
            this.mIndex = start;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public E next() {
            if (this.mIndex >= this.mEnd) {
                throw new NoSuchElementException();
            }
            return this.mElements[this.mIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Merger<S extends Storable>
    implements Iterator<S> {
        private final PriorityQueue<Iter<S>> mPQ;
        private S mNext;

        Merger(PriorityQueue<Iter<S>> pq) {
            this.mPQ = pq;
        }

        @Override
        public boolean hasNext() {
            if (this.mNext == null) {
                Iter<S> iter;
                do {
                    if ((iter = this.mPQ.poll()) != null) continue;
                    return false;
                } while ((this.mNext = iter.next()) == null);
                this.mPQ.add(iter);
                return true;
            }
            return true;
        }

        @Override
        public S next() {
            if (this.hasNext()) {
                S next = this.mNext;
                this.mNext = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputIter<S extends Storable>
    extends Iter<S> {
        private final Preparer<S> mPreparer;
        private InputStream mIn;
        private S mNext;

        InputIter(Comparator<S> comparator, Preparer<S> preparer, InputStream in) {
            super(comparator);
            this.mPreparer = preparer;
            this.mIn = in;
        }

        @Override
        S peek() {
            if (this.mNext != null) {
                return this.mNext;
            }
            if (this.mIn != null) {
                try {
                    S next = this.mPreparer.prepare();
                    next.readFrom(this.mIn);
                    this.mNext = next;
                }
                catch (EOFException e) {
                    this.mIn = null;
                }
                catch (SupportException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (IOException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            return this.mNext;
        }

        @Override
        S next() {
            S next = this.peek();
            this.mNext = null;
            return next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIter<S extends Storable>
    extends Iter<S> {
        private final S[] mArray;
        private final int mSize;
        private int mPos;

        ArrayIter(Comparator<S> comparator, S[] array, int size) {
            super(comparator);
            this.mArray = array;
            this.mSize = size;
        }

        @Override
        S peek() {
            int pos = this.mPos;
            if (pos >= this.mSize) {
                return null;
            }
            return this.mArray[pos];
        }

        @Override
        S next() {
            int pos = this.mPos;
            if (pos >= this.mSize) {
                return null;
            }
            S next = this.mArray[pos];
            this.mPos = pos + 1;
            return next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Iter<S extends Storable>
    implements Comparable<Iter<S>> {
        private final Comparator<S> mComparator;

        protected Iter(Comparator<S> comparator) {
            this.mComparator = comparator;
        }

        abstract S peek();

        abstract S next();

        @Override
        public int compareTo(Iter<S> iter) {
            S thisPeek = this.peek();
            S thatPeek = iter.peek();
            if (thisPeek == null) {
                if (thatPeek == null) {
                    return 0;
                }
                return -1;
            }
            if (thatPeek == null) {
                return 1;
            }
            return this.mComparator.compare(thisPeek, thatPeek);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromStorable<S extends Storable>
    implements Preparer<S> {
        private final S mStorable;

        FromStorable(S storable) {
            if (storable == null) {
                throw new IllegalArgumentException();
            }
            this.mStorable = storable.prepare();
        }

        @Override
        public S prepare() {
            return this.mStorable.prepare();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromStorage<S extends Storable>
    implements Preparer<S> {
        private final Storage<S> mStorage;

        FromStorage(Storage<S> storage) {
            if (storage == null) {
                throw new IllegalArgumentException();
            }
            this.mStorage = storage;
        }

        @Override
        public S prepare() {
            return this.mStorage.prepare();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Preparer<S extends Storable> {
        public S prepare();
    }
}

