/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.cursor.FilteredCursorGenerator;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mCursor;
    private S mNext;

    public static <S extends Storable> Cursor<S> applyFilter(Cursor<S> cursor, Class<S> type, String filter, Object ... filterValues) {
        Filter<S> f = Filter.filterFor(type, filter).bind();
        FilterValues<S> fv = f.initialFilterValues().withValues(filterValues);
        return FilteredCursor.applyFilter(f, fv, cursor);
    }

    public static <S extends Storable> Cursor<S> applyFilter(Filter<S> filter, FilterValues<S> filterValues, Cursor<S> cursor) {
        if (filter.isOpen()) {
            return cursor;
        }
        if (filter.isClosed()) {
            throw new IllegalArgumentException();
        }
        filter = filter.bind();
        Object[] values = filterValues == null ? null : filterValues.getValuesFor(filter);
        return FilteredCursorGenerator.getFactory(filter).newFilteredCursor(cursor, values);
    }

    protected FilteredCursor(Cursor<S> cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException();
        }
        this.mCursor = cursor;
    }

    protected abstract boolean isAllowed(S var1) throws FetchException;

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
        this.mNext = null;
    }

    @Override
    public boolean hasNext() throws FetchException {
        if (this.mNext != null) {
            return true;
        }
        try {
            int count = 0;
            while (this.mCursor.hasNext()) {
                S next = this.mCursor.next();
                if (this.isAllowed(next)) {
                    this.mNext = next;
                    return true;
                }
                this.interruptCheck(++count);
            }
        }
        catch (NoSuchElementException e) {
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return false;
    }

    @Override
    public S next() throws FetchException {
        try {
            if (this.hasNext()) {
                S next = this.mNext;
                this.mNext = null;
                return next;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (--amount >= 0 && this.hasNext()) {
                this.interruptCheck(++count);
                this.mNext = null;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void interruptCheck(int count) throws FetchException {
        if ((count & 0xFFFFFF00) == 0 && Thread.interrupted()) {
            this.close();
            throw new FetchInterruptedException();
        }
    }
}

