/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursor<S>
implements Cursor<S> {
    protected AbstractCursor() {
    }

    @Override
    public int copyInto(Collection<? super S> c) throws FetchException {
        try {
            int count = 0;
            while (this.hasNext()) {
                c.add(this.next());
                ++count;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int copyInto(Collection<? super S> c, int limit) throws FetchException {
        try {
            int count = 0;
            while (--limit >= 0 && this.hasNext()) {
                c.add(this.next());
                ++count;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public List<S> toList() throws FetchException {
        try {
            ArrayList list = new ArrayList();
            this.copyInto(list);
            return list;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public List<S> toList(int limit) throws FetchException {
        try {
            ArrayList list = new ArrayList();
            this.copyInto(list, limit);
            return list;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (--amount >= 0 && this.hasNext()) {
                this.next();
                ++count;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

