/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.constraint;

import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.constraint.ConstraintDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@ConstraintDefinition
public @interface IntegerConstraint {
    public long[] allowed() default {};

    public long[] disallowed() default {};

    public long min() default -9223372036854775808L;

    public long max() default 0x7FFFFFFFFFFFFFFFL;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint {
        private final String mPropertyName;
        private final long mMinValue;
        private final long mMaxValue;
        private final long[] mDisallowed;
        private final long[] mAllowed;

        public Constraint(Class<?> type, String propertyName, IntegerConstraint ann) {
            this(type, propertyName, ann.min(), ann.max(), ann.allowed(), ann.disallowed());
        }

        public Constraint(Class<?> type, String propertyName, long min, long max, long[] allowed, long[] disallowed) {
            this.mPropertyName = propertyName;
            this.mMinValue = min;
            this.mMaxValue = max;
            if (this.mMaxValue < this.mMinValue) {
                throw new MalformedTypeException(type, "Illegal range for integer constraint on property \"" + propertyName + "\": " + this.rangeString());
            }
            if (disallowed == null || disallowed.length == 0) {
                disallowed = null;
            } else {
                disallowed = (long[])disallowed.clone();
                Arrays.sort(disallowed);
            }
            if (allowed == null || allowed.length == 0) {
                allowed = null;
            } else {
                allowed = (long[])allowed.clone();
                Arrays.sort(allowed);
                for (long value : allowed) {
                    if (value >= this.mMinValue && value <= this.mMaxValue && (disallowed == null || Arrays.binarySearch(disallowed, value) < 0)) continue;
                    throw new MalformedTypeException(type, "Allowed value contradiction for integer constraint on property \"" + propertyName + "\": " + value);
                }
                disallowed = null;
            }
            this.mDisallowed = disallowed;
            this.mAllowed = allowed;
        }

        public void constrain(long propertyValue) {
            if (propertyValue < this.mMinValue || propertyValue > this.mMaxValue) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" must be in range " + this.rangeString() + ": " + propertyValue);
            }
            if (this.mDisallowed != null && Arrays.binarySearch(this.mDisallowed, propertyValue) >= 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is disallowed: " + propertyValue);
            }
            if (this.mAllowed != null && Arrays.binarySearch(this.mAllowed, propertyValue) < 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not allowed: " + propertyValue);
            }
        }

        public void constrain(double propertyValue) {
            long longValue;
            if (propertyValue < (double)this.mMinValue || propertyValue > (double)this.mMaxValue) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" must be in range " + this.rangeString() + ": " + propertyValue);
            }
            if (this.mDisallowed != null && (double)(longValue = (long)propertyValue) == propertyValue && Arrays.binarySearch(this.mDisallowed, longValue) >= 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is disallowed: " + propertyValue);
            }
            if (this.mAllowed != null && ((double)(longValue = (long)propertyValue) != propertyValue || Arrays.binarySearch(this.mAllowed, longValue) < 0)) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not allowed: " + propertyValue);
            }
        }

        public void constrain(CharSequence propertyValue) {
            if (propertyValue != null) {
                try {
                    this.constrain(Long.parseLong(((Object)propertyValue).toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not an integer: " + propertyValue);
                }
            }
        }

        public void constrain(char propertyValue) {
            if ('0' > propertyValue || propertyValue > '9') {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not an integer: " + propertyValue);
            }
            this.constrain(propertyValue - 48);
        }

        public void constrain(char[] propertyValue) {
            if (propertyValue != null) {
                this.constrain(new String(propertyValue));
            }
        }

        private String rangeString() {
            StringBuilder b = new StringBuilder();
            b.append('(');
            if (this.mMinValue > Long.MIN_VALUE) {
                b.append(this.mMinValue);
            }
            b.append("..");
            if (this.mMaxValue < Long.MAX_VALUE) {
                b.append(this.mMaxValue);
            }
            b.append(')');
            return b.toString();
        }
    }
}

