/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.rep.AppStateMonitor;
import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.BinaryNodeStateService;
import com.sleepycat.je.rep.impl.GroupService;
import com.sleepycat.je.rep.impl.NodeStateService;
import com.sleepycat.je.rep.impl.PointConsistencyPolicy;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.ChannelTimeoutTask;
import com.sleepycat.je.rep.impl.node.CommitFreezeLatch;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.GlobalCBVLSN;
import com.sleepycat.je.rep.impl.node.JoinGroupTimeouts;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNTracker;
import com.sleepycat.je.rep.impl.node.LogFlusher;
import com.sleepycat.je.rep.impl.node.MonitorEventManager;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.NodeState;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.ReplicaFactory;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.stream.FeederTxns;
import com.sleepycat.je.rep.stream.MasterChangeListener;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.MasterSuggestionGenerator;
import com.sleepycat.je.rep.util.ldiff.LDiffService;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepNode
extends StoppableThread {
    private final NameIdPair nameIdPair;
    private final InetSocketAddress mySocket;
    private final ServiceDispatcher serviceDispatcher;
    private Elections elections;
    private final Replica replica;
    private final FeederManager feederManager;
    private final MasterStatus masterStatus;
    private final MasterChangeListener changeListener;
    private final MasterSuggestionGenerator suggestionGenerator;
    private final NodeState nodeState;
    private volatile boolean activePrimary = false;
    private int electableGroupSizeOverride;
    private final RepImpl repImpl;
    final RepGroupDB repGroupDB;
    private volatile RepUtils.ExceptionAwareCountDownLatch readyLatch = null;
    private final CommitFreezeLatch vlsnFreezeLatch = new CommitFreezeLatch();
    private RepGroupImpl group;
    private volatile VLSN currentTxnEndVLSN = null;
    private QuorumPolicy electionQuorumPolicy = QuorumPolicy.SIMPLE_MAJORITY;
    private static final int MASTER_QUERY_INTERVAL = 10000;
    private static final int JOIN_RETRIES = 10;
    private final Clock clock;
    private com.sleepycat.je.rep.impl.networkRestore.FeederManager logFeederManager;
    private LDiffService ldiff;
    private NodeStateService nodeStateService;
    private BinaryNodeStateService binaryNodeStateService;
    final LocalCBVLSNTracker cbvlsnTracker;
    final GlobalCBVLSN globalCBVLSN;
    private long replicaCloseCatchupMs = -1L;
    private MonitorEventManager monitorEventManager;
    private AppStateMonitor appStateMonitor;
    private final Timer timer;
    private final ChannelTimeoutTask channelTimeoutTask;
    private LogFlusher logFlusher;
    final Logger logger;
    private TestHook<Integer> versionHook;
    private TestHook<Thread> masterTransferHook;

    public RepNode(RepImpl repImpl, Replay replay, NodeState nodeState) throws IOException, DatabaseException {
        super(repImpl, "RepNode " + repImpl.getNameIdPair());
        this.repImpl = repImpl;
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(repImpl, 1);
        this.nameIdPair = repImpl.getNameIdPair();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.mySocket = repImpl.getSocket();
        this.serviceDispatcher = new ServiceDispatcher(this.mySocket, repImpl);
        this.serviceDispatcher.start();
        this.clock = new Clock(RepImpl.getClockSkewMs());
        this.repGroupDB = new RepGroupDB(repImpl);
        this.masterStatus = new MasterStatus(this.nameIdPair);
        this.replica = ReplicaFactory.create(this, replay);
        this.feederManager = new FeederManager(this);
        this.changeListener = new MasterChangeListener(this);
        this.suggestionGenerator = new MasterSuggestionGenerator(this);
        this.nodeState = nodeState;
        this.electableGroupSizeOverride = repImpl.getConfigManager().getInt(RepParams.ELECTABLE_GROUP_SIZE_OVERRIDE);
        if (this.electableGroupSizeOverride > 0) {
            LoggerUtils.warning(this.logger, repImpl, "Electable group size override set to:" + this.electableGroupSizeOverride);
        }
        this.utilityServicesStart();
        this.cbvlsnTracker = new LocalCBVLSNTracker(this);
        this.globalCBVLSN = new GlobalCBVLSN(this);
        this.monitorEventManager = new MonitorEventManager(this);
        this.timer = new Timer(true);
        this.channelTimeoutTask = new ChannelTimeoutTask(this.timer);
        this.configLogFlusher(this.getConfigManager());
    }

    private void utilityServicesStart() {
        this.ldiff = new LDiffService(this.serviceDispatcher, this.repImpl);
        this.logFeederManager = new com.sleepycat.je.rep.impl.networkRestore.FeederManager(this.serviceDispatcher, this.repImpl, this.nameIdPair);
        this.nodeStateService = new NodeStateService(this.serviceDispatcher, this);
        this.serviceDispatcher.register(this.nodeStateService);
        this.binaryNodeStateService = new BinaryNodeStateService(this.serviceDispatcher, this);
    }

    public RepNode(NameIdPair nameIdPair) {
        this(nameIdPair, null);
    }

    public RepNode() {
        this(NameIdPair.NULL);
    }

    public RepNode(NameIdPair nameIdPair, ServiceDispatcher serviceDispatcher) {
        super("RepNode " + nameIdPair);
        this.repImpl = null;
        this.clock = new Clock(0);
        this.nameIdPair = nameIdPair;
        this.mySocket = null;
        this.serviceDispatcher = serviceDispatcher;
        this.repGroupDB = null;
        this.masterStatus = new MasterStatus(NameIdPair.NULL);
        this.replica = null;
        this.feederManager = null;
        this.changeListener = null;
        this.suggestionGenerator = null;
        this.nodeState = null;
        this.cbvlsnTracker = null;
        this.globalCBVLSN = null;
        this.logger = null;
        this.timer = null;
        this.channelTimeoutTask = null;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public ServiceDispatcher getServiceDispatcher() {
        return this.serviceDispatcher;
    }

    public ReplicatedEnvironmentStats getStats(StatsConfig config) {
        ReplicatedEnvironmentStats ret = RepInternal.makeReplicatedEnvironmentStats(this.feederManager, this.replica, this.repImpl.getVLSNIndex(), config);
        return ret;
    }

    public void resetStats() {
        this.feederManager.resetStats();
        this.replica.resetStats();
    }

    public RepUtils.ExceptionAwareCountDownLatch getReadyLatch() {
        return this.readyLatch;
    }

    public CommitFreezeLatch getVLSNFreezeLatch() {
        return this.vlsnFreezeLatch;
    }

    public void resetReadyLatch(Exception exception) {
        if (this.readyLatch.getCount() != 0L) {
            this.readyLatch.releaseAwait(exception);
        }
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(this.repImpl, 1);
    }

    public FeederManager feederManager() {
        return this.feederManager;
    }

    public Replica replica() {
        return this.replica;
    }

    public Clock getClock() {
        return this.clock;
    }

    Replica getReplica() {
        return this.replica;
    }

    public RepGroupDB getRepGroupDB() {
        return this.repGroupDB;
    }

    public RepGroupImpl getGroup() {
        return this.group;
    }

    public UUID getUUID() {
        if (this.group == null) {
            throw EnvironmentFailureException.unexpectedState("Group info is not available");
        }
        return this.group.getUUID();
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public int getNodeId() {
        return this.nameIdPair.getId();
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    public InetSocketAddress getSocket() {
        return this.mySocket;
    }

    public MasterStatus getMasterStatus() {
        return this.masterStatus;
    }

    public boolean isAuthoritativeMaster() {
        if (!this.getMasterStatus().isGroupMaster()) {
            return false;
        }
        return this.feederManager.activeReplicaCount() + 1 >= this.getElectionQuorumSize(QuorumPolicy.SIMPLE_MAJORITY);
    }

    public int getHeartbeatInterval() {
        return this.getConfigManager().getInt(RepParams.HEARTBEAT_INTERVAL);
    }

    public void setVersionHook(TestHook<Integer> versionHook) {
        this.versionHook = versionHook;
    }

    public void setMasterTransferHook(TestHook<Thread> masterTransferHook) {
        this.masterTransferHook = masterTransferHook;
    }

    public int getLogVersion() {
        if (this.versionHook != null) {
            return this.versionHook.getHookValue();
        }
        return 8;
    }

    public int getElectionPriority() {
        int priority = this.getConfigManager().getInt(RepParams.NODE_PRIORITY);
        int defaultPriority = Integer.parseInt(RepParams.NODE_PRIORITY.getDefault());
        return this.getConfigManager().getBoolean(RepParams.DESIGNATED_PRIMARY) && priority == defaultPriority ? defaultPriority + 1 : priority;
    }

    public int getThreadWaitInterval() {
        return this.getHeartbeatInterval() * 4;
    }

    int getDbTreeCacheClearingOpCount() {
        return this.getConfigManager().getInt(RepParams.DBTREE_CACHE_CLEAR_COUNT);
    }

    public RepImpl getRepImpl() {
        return this.repImpl;
    }

    public LogManager getLogManager() {
        return this.repImpl.getLogManager();
    }

    DbConfigManager getConfigManager() {
        return this.repImpl.getConfigManager();
    }

    public VLSNIndex getVLSNIndex() {
        return this.repImpl.getVLSNIndex();
    }

    public FeederTxns getFeederTxns() {
        return this.repImpl.getFeederTxns();
    }

    public Elections getElections() {
        return this.elections;
    }

    public MasterSuggestionGenerator getSuggestionGenerator() {
        return this.suggestionGenerator;
    }

    public QuorumPolicy getElectionPolicy() {
        return this.electionQuorumPolicy;
    }

    public RepNodeImpl[] getLogProviders() {
        Set<RepNodeImpl> nodes = this.getGroup().getAllElectableMembers();
        RepNodeImpl[] logProviders = new RepNodeImpl[nodes.size()];
        int i = 0;
        for (RepNodeImpl node : nodes) {
            logProviders[i++] = node;
        }
        return logProviders;
    }

    public LogFlusher getLogFlusher() {
        return this.logFlusher;
    }

    public void configLogFlusher(DbConfigManager configMgr) {
        boolean enableTask = configMgr.getBoolean(RepParams.RUN_LOG_FLUSH_TASK);
        int flushInterval = configMgr.getDuration(RepParams.LOG_FLUSH_TASK_INTERVAL);
        if (!enableTask) {
            if (this.logFlusher != null) {
                this.logFlusher.cancelTask();
            }
            return;
        }
        if (this.logFlusher == null) {
            this.logFlusher = new LogFlusher(this, this.timer);
        }
        this.logFlusher.configFlushTask(flushInterval);
    }

    public ChannelTimeoutTask getChannelTimeoutTask() {
        return this.channelTimeoutTask;
    }

    public boolean isMaster() {
        return this.masterStatus.isNodeMaster();
    }

    public void currentTxnEndVLSN(VLSN txnEndVLSN) {
        this.currentTxnEndVLSN = txnEndVLSN;
    }

    public MonitorEventManager getMonitorEventManager() {
        return this.monitorEventManager;
    }

    public void registerAppStateMonitor(AppStateMonitor stateMonitor) {
        this.appStateMonitor = stateMonitor;
    }

    public byte[] getAppState() {
        if (this.appStateMonitor == null || this.appStateMonitor.getAppState() == null) {
            return null;
        }
        if (this.appStateMonitor.getAppState().length == 0) {
            throw new IllegalStateException("Application state should be a byte array larger than 0.");
        }
        return this.appStateMonitor.getAppState();
    }

    public String getMasterName() {
        if (this.masterStatus.getGroupMasterNameId().getId() == -1) {
            return null;
        }
        return this.masterStatus.getGroupMasterNameId().getName();
    }

    public VLSN getCurrentTxnEndVLSN() {
        return this.currentTxnEndVLSN;
    }

    public void forceMaster(boolean force) throws InterruptedException, DatabaseException {
        this.suggestionGenerator.forceMaster(force);
        this.refreshCachedGroup();
        this.elections.initiateElection(this.group, this.electionQuorumPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup(QuorumPolicy initialElectionPolicy) throws IOException, DatabaseException {
        if (this.isAlive()) {
            return;
        }
        assert (this.nodeState.getRepEnvState().isDetached());
        this.elections = new Elections(this, this.changeListener, this.suggestionGenerator);
        this.repImpl.getStartupTracker().start(StartupTracker.Phase.FIND_MASTER);
        try {
            if (this.repImpl.getConfigManager().getBoolean(RepParams.RESET_REP_GROUP)) {
                this.reinitSelfElect();
            } else {
                this.findMaster();
            }
            this.electionQuorumPolicy = initialElectionPolicy;
            this.elections.participate();
        }
        finally {
            this.repImpl.getStartupTracker().stop(StartupTracker.Phase.FIND_MASTER);
        }
        this.start();
    }

    public RepGroupImpl refreshCachedGroup() throws DatabaseException {
        RepNodeImpl n;
        this.group = this.repGroupDB.getGroup(new NoConsistencyRequiredPolicy());
        this.elections.updateRepGroup(this.group);
        if (this.nameIdPair.hasNullId() && (n = this.group.getMember(this.nameIdPair.getName())) != null) {
            this.nameIdPair.update(n.getNameIdPair());
        }
        return this.group;
    }

    public void removeMember(String nodeName) {
        this.checkValidity(nodeName, "Removing member");
        RepNodeImpl node = this.group.removeMember(nodeName);
        this.feederManager.shutdownFeeder(node);
        this.repGroupDB.removeMember(node);
    }

    public void updateAddress(String nodeName, String newHostName, int newPort) {
        this.checkValidity(nodeName, "Updating node's address");
        if (this.feederManager.getFeeder(nodeName) != null) {
            throw new ReplicaStateException("Can't update the network address for a live node.");
        }
        RepNodeImpl node = this.group.getNode(nodeName);
        node.setHostName(newHostName);
        node.setPort(newPort);
        this.repGroupDB.updateMember(node);
    }

    public synchronized void transferMaster(String nodeName) {
        this.checkValidity(nodeName, "Transferring mastership");
        Feeder feeder = this.feederManager.getFeeder(nodeName);
        if (feeder == null) {
            throw new MasterTransferFailureException("Replica is going to be the master is not alive, transfer fails, master doesn't change.");
        }
        long catchupTimeout = this.getConfigManager().getDuration(RepParams.CATCHUP_MASTER_TIMEOUT);
        long catchupPhase2Timeout = this.getConfigManager().getDuration(RepParams.CATCHUP_MASTER_PHASE2_TIMEOUT);
        try {
            this.replicaCatchupMaster(feeder, catchupTimeout, true);
            this.repImpl.createAndSetBlockLatch();
            this.replicaCatchupMaster(feeder, catchupPhase2Timeout, false);
        }
        catch (Exception e) {
            this.repImpl.countDownBlockLatch();
            throw new MasterTransferFailureException(e.getMessage());
        }
        TestHookExecute.doHookIfSet(this.masterTransferHook);
        this.broadcastMessage(nodeName);
    }

    private void replicaCatchupMaster(Feeder feeder, long catchTime, boolean useOldTxnEndVLSN) {
        try {
            long targetVLSN = this.currentTxnEndVLSN.getSequence();
            CountDownLatch syncLatch = new CountDownLatch(1);
            feeder.setSyncLatch(syncLatch);
            syncLatch.await(catchTime, TimeUnit.MILLISECONDS);
            if (!useOldTxnEndVLSN) {
                targetVLSN = this.currentTxnEndVLSN.getSequence();
            }
            if (feeder.getFeederVLSN().getSequence() < targetVLSN) {
                throw new MasterTransferFailureException("Replica can't catch up the master, replica VLSN: " + feeder.getFeederVLSN() + " while master's latest " + "transaction end VLSN: " + targetVLSN + ". Transfer fails, master doesn't change");
            }
        }
        catch (InterruptedException e) {
            throw new MasterTransferFailureException("Replica catching up with master is interrupted, transfer fails, master doesn't change.");
        }
    }

    private void broadcastMessage(String nodeName) {
        RepNodeImpl node = this.group.getNode(nodeName);
        MasterValue newMaster = new MasterValue(node.getSocketAddress().getAddress().getHostAddress(), node.getSocketAddress().getPort(), node.getNameIdPair());
        Proposer.Proposal proposal = new TimebasedProposalGenerator().nextProposal();
        this.elections.getLearner();
        Learner.informLearners(this.group.getLearnerSockets(), new Proposer.WinningProposal(proposal, newMaster, null), this.elections.getProtocol(), this.elections.getThreadPool(), this.elections.getLogger(), this.repImpl, null);
    }

    private void checkValidity(String nodeName, String actionName) throws MemberNotFoundException {
        if (!this.nodeState.getRepEnvState().isMaster()) {
            throw EnvironmentFailureException.unexpectedState("Not currently a master. " + actionName + " must be " + "invoked on the node that's currently the master.");
        }
        RepNodeImpl node = this.group.getNode(nodeName);
        if (node == null) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not a member of the group:" + this.group.getName());
        }
        if (node.isRemoved() && node.isQuorumAck()) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not currently a member of " + "the group:" + this.group.getName() + " It had been removed.");
        }
        if (nodeName.equals(this.getNodeName())) {
            throw new MasterStateException(this.getRepImpl().getStateChangeEvent());
        }
    }

    public void updateGroupInfo(NameIdPair updateNameIdPair, RepGroupImpl.BarrierState barrierState) {
        RepNodeImpl node = this.group.getMember(updateNameIdPair.getName());
        if (node == null) {
            return;
        }
        LoggerUtils.fine(this.logger, this.repImpl, "LocalCBVLSN for " + updateNameIdPair + " updated to " + barrierState + " from " + node.getBarrierState().getLastCBVLSN());
        node.setBarrierState(barrierState);
        this.globalCBVLSN.recalculate(this.group);
    }

    void recalculateGlobalCBVLSN() {
        this.globalCBVLSN.recalculate(this.group);
    }

    LocalCBVLSNTracker getCBVLSNTracker() {
        return this.cbvlsnTracker;
    }

    public void freezeLocalCBVLSN() {
        this.cbvlsnTracker.incrementFreezeCounter();
    }

    public void unfreezeLocalCBVLSN() {
        this.cbvlsnTracker.decrementFreezeCounter();
    }

    private void findMaster() throws IOException, DatabaseException {
        this.refreshCachedGroup();
        this.elections.startLearner();
        LoggerUtils.info(this.logger, this.repImpl, "Current group size: " + this.group.getElectableGroupSize());
        RepNodeImpl thisNode = this.group.getNode(this.nameIdPair.getName());
        if (thisNode == null) {
            LoggerUtils.info(this.logger, this.repImpl, "New node " + this.nameIdPair + " unknown to rep group");
            Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
            if (this.group.getElectableGroupSize() == 0 && helperSockets.size() == 1 && this.serviceDispatcher.getSocketAddress().equals(helperSockets.iterator().next())) {
                this.selfElect();
                this.elections.updateRepGroup(this.group);
                return;
            }
            this.queryGroupForMaster();
        } else {
            if (thisNode.isRemoved()) {
                throw EnvironmentFailureException.unexpectedState("Node: " + this.nameIdPair.getName() + " was previously deleted.");
            }
            LoggerUtils.info(this.logger, this.repImpl, "Existing node " + this.nameIdPair.getName() + " querying for a current master.");
            Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
            helperSockets.addAll(this.group.getLearnerSockets());
            this.elections.getLearner().queryForMaster(helperSockets);
        }
    }

    private void checkLoopbackAddresses(Set<InetSocketAddress> helperSockets) {
        InetAddress myAddress = this.mySocket.getAddress();
        boolean isLoopback = myAddress.isLoopbackAddress();
        for (InetSocketAddress socketAddress : helperSockets) {
            InetAddress nodeAddress = socketAddress.getAddress();
            if (nodeAddress.isLoopbackAddress() == isLoopback) continue;
            String message = this.mySocket + " the address associated with this node, " + (isLoopback ? "is " : "is not ") + "a loopback address." + " It conflicts with an existing use, by a different node " + " of the address:" + socketAddress + (!isLoopback ? " which is a loopback address." : " which is not a loopback address.") + " Such mixing of addresses within a group is not allowed, " + "since the nodes will not be able to communicate with " + "each other.";
            throw new IllegalArgumentException(message);
        }
    }

    private void queryGroupForMaster() {
        Set<InetSocketAddress> helperSockets = this.repImpl.getHelperSockets();
        this.checkLoopbackAddresses(helperSockets);
        HashSet<InetSocketAddress> learners = new HashSet<InetSocketAddress>(helperSockets);
        learners.addAll(this.group.getLearnerSockets());
        if (learners.size() == 0) {
            throw EnvironmentFailureException.unexpectedState("Need a helper to add a new node into the group");
        }
        while (true) {
            this.elections.getLearner().queryForMaster(learners);
            if (this.masterStatus.getGroupMasterNameId().getId() != -1) break;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }
        LoggerUtils.info(this.logger, this.repImpl, "New node " + this.nameIdPair.getName() + " located master: " + this.masterStatus.getGroupMasterNameId());
    }

    private void selfElect() throws DatabaseException {
        this.nameIdPair.setId(RepGroupImpl.getFirstNodeId());
        Proposer.Proposal proposal = new TimebasedProposalGenerator().nextProposal();
        this.elections.getLearner().processResult(proposal, this.suggestionGenerator.get(proposal));
        LoggerUtils.info(this.logger, this.repImpl, "Nascent group. " + this.nameIdPair.getName() + " is master by virtue of being the first node.");
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
        this.masterStatus.sync();
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, this.masterStatus.getNodeMasterNameId());
        this.repImpl.getVLSNIndex().initAsMaster();
        this.repGroupDB.addFirstNode();
        this.refreshCachedGroup();
        this.masterStatus.unSync();
    }

    void reinitSelfElect() throws IOException {
        this.group = this.repGroupDB.emptyGroup;
        LoggerUtils.info(this.logger, this.repImpl, "Reinitializing group to node " + this.nameIdPair);
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, this.masterStatus.getNodeMasterNameId());
        this.repImpl.getVLSNIndex().initAsMaster();
        this.repImpl.forceLogFileFlip();
        CheckpointConfig ckptConfig = new CheckpointConfig();
        ckptConfig.setForce(true);
        this.repImpl.getCheckpointer().doCheckpoint(ckptConfig, "Reinit of RepGroup");
        VLSN lastOldVLSN = this.repImpl.getVLSNIndex().getRange().getLast();
        this.repGroupDB.reinitFirstNode(lastOldVLSN);
        this.refreshCachedGroup();
        long lastOldFile = this.repImpl.getVLSNIndex().getLTEFileNumber(lastOldVLSN);
        this.repImpl.getVLSNIndex().truncateFromHead(lastOldVLSN, lastOldFile);
        this.elections.startLearner();
        this.masterStatus.unSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block55: {
            block49: {
                block54: {
                    block48: {
                        if (this.nodeState.getRepEnvState().isDetached()) {
                            this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
                        }
                        repNodeError = null;
                        try {
                            try {
                                LoggerUtils.info(this.logger, this.repImpl, "Node " + this.nameIdPair.getName() + " started");
                                while (!this.isShutdown()) {
                                    if (this.nodeState.getRepEnvState() != ReplicatedEnvironment.State.UNKNOWN) {
                                        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.UNKNOWN, NameIdPair.NULL);
                                    }
                                    if (this.masterStatus.getGroupMasterNameId().hasNullId() || this.masterStatus.inSync()) {
                                        this.elections.initiateElection(this.group, this.electionQuorumPolicy);
                                        this.electionQuorumPolicy = QuorumPolicy.SIMPLE_MAJORITY;
                                        if (this.isShutdown()) {
                                            var6_8 = null;
                                            break block48;
                                        }
                                    }
                                    this.masterStatus.sync();
                                    status = (MasterStatus)this.masterStatus.clone();
                                    if (status.isNodeMaster()) {
                                        this.repImpl.getVLSNIndex().initAsMaster();
                                        this.replica.masterTransitionCleanup();
                                        try {
                                            this.serviceDispatcher.register(new GroupService(this.serviceDispatcher, this));
                                            this.nodeState.changeAndNotify(ReplicatedEnvironment.State.MASTER, status.getNodeMasterNameId());
                                            this.feederManager.runFeeders();
                                            var4_7 = null;
                                            this.serviceDispatcher.cancel("Group");
                                            continue;
                                        }
                                        catch (Throwable var3_32) {
                                            var4_7 = null;
                                            this.serviceDispatcher.cancel("Group");
                                            throw var3_32;
                                        }
                                    }
                                    this.nodeState.changeAndNotify(ReplicatedEnvironment.State.REPLICA, status.getNodeMasterNameId());
                                    this.replica.runReplicaLoop();
                                }
                                break block49;
                            }
                            catch (InterruptedException e) {
                                LoggerUtils.fine(this.logger, this.repImpl, "RepNode main thread interrupted -  forced shutdown.");
                                var6_10 = null;
                                try {
                                    LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                                    if (repNodeError != null) {
                                        LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                        throw repNodeError;
                                    }
                                    exception = this.getSavedShutdownException();
                                    if (exception == null) {
                                        LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                    } else {
                                        LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                                    }
                                    try {
                                        this.shutdown();
                                    }
                                    catch (DatabaseException e) {
                                        RepUtils.chainExceptionCause(e, exception);
                                        LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                                        throw e;
                                    }
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                                this.cleanup();
                                return;
                            }
                            catch (GroupShutdownException e) {
                                block51: {
                                    this.saveShutdownException(e);
                                    var6_11 = null;
                                    ** try [egrp 3[TRYBLOCK] [17 : 369->577)] { 
lbl72:
                                    // 1 sources

                                    LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                                    if (repNodeError != null) {
                                        LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                        throw repNodeError;
                                    }
                                    exception = this.getSavedShutdownException();
                                    if (exception == null) {
                                        LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                    } else {
                                        LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                                    }
                                    try {}
                                    catch (DatabaseException e) {
                                        RepUtils.chainExceptionCause(e, exception);
                                        LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                                        throw e;
                                    }
                                    this.shutdown();
                                    break block51;
lbl89:
                                    // 1 sources

                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                }
                                this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                                this.cleanup();
                                return;
                            }
                            catch (RuntimeException e) {
                                this.saveShutdownException(e);
                                throw e;
                            }
                            catch (Error e) {
                                block52: {
                                    repNodeError = e;
                                    this.repImpl.invalidate(e);
                                    var6_12 = null;
                                    ** try [egrp 3[TRYBLOCK] [17 : 369->577)] { 
lbl104:
                                    // 1 sources

                                    LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                                    if (repNodeError != null) {
                                        LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                        throw repNodeError;
                                    }
                                    exception = this.getSavedShutdownException();
                                    if (exception == null) {
                                        LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                    } else {
                                        LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                                    }
                                    try {}
                                    catch (DatabaseException e) {
                                        RepUtils.chainExceptionCause(e, exception);
                                        LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                                        throw e;
                                    }
                                    this.shutdown();
                                    break block52;
lbl121:
                                    // 1 sources

                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                }
                                this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                                this.cleanup();
                                return;
                            }
                        }
                        catch (Throwable var5_33) {
                            block53: {
                                var6_13 = null;
                                ** try [egrp 3[TRYBLOCK] [17 : 369->577)] { 
lbl131:
                                // 1 sources

                                LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                                if (repNodeError != null) {
                                    LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                    throw repNodeError;
                                }
                                exception = this.getSavedShutdownException();
                                if (exception == null) {
                                    LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                                } else {
                                    LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                                }
                                try {}
                                catch (DatabaseException e) {
                                    RepUtils.chainExceptionCause(e, exception);
                                    LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                                    throw e;
                                }
                                this.shutdown();
                                break block53;
lbl148:
                                // 1 sources

                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                            }
                            this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                            this.cleanup();
                            throw var5_33;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [17 : 369->577)] { 
lbl156:
                    // 1 sources

                    LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
                    if (repNodeError != null) {
                        LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                        throw repNodeError;
                    }
                    exception = this.getSavedShutdownException();
                    if (exception == null) {
                        LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                    } else {
                        LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
                    }
                    try {}
                    catch (DatabaseException e) {
                        RepUtils.chainExceptionCause(e, exception);
                        LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                        throw e;
                    }
                    this.shutdown();
                    break block54;
lbl173:
                    // 1 sources

                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
                this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
                this.cleanup();
                return;
            }
            var6_9 = null;
            ** try [egrp 3[TRYBLOCK] [17 : 369->577)] { 
lbl182:
            // 1 sources

            LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread shutting down.");
            if (repNodeError != null) {
                LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                throw repNodeError;
            }
            exception = this.getSavedShutdownException();
            if (exception == null) {
                LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
            } else {
                LoggerUtils.info(this.logger, this.repImpl, "RepNode shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
            }
            try {}
            catch (DatabaseException e) {
                RepUtils.chainExceptionCause(e, exception);
                LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                throw e;
            }
            this.shutdown();
            break block55;
lbl199:
            // 1 sources

            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        this.nodeState.changeAndNotify(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
        this.cleanup();
    }

    public void shutdown() throws InterruptedException, DatabaseException {
        if (this.shutdownDone()) {
            return;
        }
        LoggerUtils.info(this.logger, this.repImpl, "Shutting down node " + this.nameIdPair);
        if (this.repImpl.isValid()) {
            this.monitorEventManager.notifyLeaveGroup(this.getLeaveReason());
        }
        this.serviceDispatcher.preShutdown();
        if (this.elections != null) {
            this.elections.shutdown();
        }
        this.feederManager.shutdownQueue();
        if (this.getReplicaCloseCatchupMs() >= 0L && this.nodeState.getRepEnvState().isMaster()) {
            this.join();
        }
        this.replica.shutdown();
        this.shutdownThread(this.logger);
        LoggerUtils.info(this.logger, this.repImpl, "RepNode main thread: " + this.getName() + " exited.");
        this.utilityServicesShutdown();
        this.serviceDispatcher.shutdown();
        LoggerUtils.info(this.logger, this.repImpl, this.nameIdPair + " shutdown completed.");
        this.masterStatus.setGroupMaster(null, NameIdPair.NULL);
        this.readyLatch.releaseAwait(this.getSavedShutdownException());
        this.channelTimeoutTask.cancel();
        if (this.logFlusher != null) {
            this.logFlusher.cancelTask();
        }
        this.timer.cancel();
    }

    @Override
    protected int initiateSoftShutdown() {
        return this.getThreadWaitInterval();
    }

    private LeaveGroupEvent.LeaveReason getLeaveReason() {
        LeaveGroupEvent.LeaveReason reason = null;
        Exception exception = this.getSavedShutdownException();
        reason = exception == null ? LeaveGroupEvent.LeaveReason.NORMAL_SHUTDOWN : (exception instanceof GroupShutdownException ? LeaveGroupEvent.LeaveReason.MASTER_SHUTDOWN_GROUP : LeaveGroupEvent.LeaveReason.ABNORMAL_TERMINATION);
        return reason;
    }

    private void utilityServicesShutdown() {
        if (this.ldiff != null) {
            this.ldiff.shutdown();
        }
        if (this.logFeederManager != null) {
            this.logFeederManager.shutdown();
        }
        if (this.binaryNodeStateService != null) {
            this.binaryNodeStateService.shutdown();
        }
        if (this.nodeStateService != null) {
            this.serviceDispatcher.cancel("NodeState");
        }
    }

    public void shutdownGroupOnClose(long timeoutMs) throws IllegalStateException {
        if (!this.nodeState.getRepEnvState().isMaster()) {
            throw new IllegalStateException("Node state must be " + (Object)((Object)ReplicatedEnvironment.State.MASTER) + ", not " + (Object)((Object)this.nodeState.getRepEnvState()));
        }
        this.replicaCloseCatchupMs = timeoutMs < 0L ? 0L : timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplicatedEnvironment.State joinGroup(ReplicaConsistencyPolicy consistency, QuorumPolicy initialElectionPolicy) throws ReplicaConsistencyException, DatabaseException, IOException {
        int retries;
        DatabaseException exitException;
        block21: {
            JoinGroupTimeouts timeouts = new JoinGroupTimeouts(this.getConfigManager());
            this.startup(initialElectionPolicy);
            LoggerUtils.finest(this.logger, this.repImpl, "joinGroup " + (Object)((Object)this.nodeState.getRepEnvState()));
            exitException = null;
            retries = 0;
            this.repImpl.getStartupTracker().start(StartupTracker.Phase.BECOME_CONSISTENT);
            this.repImpl.getStartupTracker().setProgress(RecoveryProgress.BECOME_CONSISTENT);
            try {
                block14: for (retries = 0; retries < 10; ++retries) {
                    ReplicatedEnvironment.State state;
                    ReplicatedEnvironment.State finalState;
                    block20: {
                        boolean done = this.getReadyLatch().awaitOrException(timeouts.getTimeout(), TimeUnit.MILLISECONDS);
                        finalState = this.nodeState.getRepEnvState();
                        if (done) break block20;
                        if (finalState.isReplica()) {
                            if (!timeouts.timeoutIsForUnknownState()) {
                                throw new ReplicaConsistencyException(String.format("Setup time exceeded %,d ms", timeouts.getSetupTimeout()), null);
                            }
                            timeouts.setSetupTimeout();
                            continue;
                        }
                        if (!finalState.isUnknown() || !timeouts.timeoutIsForUnknownState()) break block21;
                        ReplicatedEnvironment.State state2 = ReplicatedEnvironment.State.UNKNOWN;
                        Object var10_14 = null;
                        this.repImpl.getStartupTracker().stop(StartupTracker.Phase.BECOME_CONSISTENT);
                        return state2;
                    }
                    try {
                        switch (finalState) {
                            case UNKNOWN: {
                                continue block14;
                            }
                            case REPLICA: {
                                this.joinAsReplica(consistency);
                                break;
                            }
                            case MASTER: {
                                LoggerUtils.info(this.logger, this.repImpl, "Joining group as master");
                                break;
                            }
                            case DETACHED: {
                                throw EnvironmentFailureException.unexpectedState("Node in DETACHED state while joining group.");
                            }
                        }
                        state = finalState;
                    }
                    catch (InterruptedException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    catch (MasterStateException e) {
                        LoggerUtils.warning(this.logger, this.repImpl, "Join retry due to master transition: " + e.getMessage());
                        continue;
                    }
                    catch (RestartRequiredException e) {
                        LoggerUtils.warning(this.logger, this.repImpl, "Environment needs to be restarted: " + e.getMessage());
                        throw e;
                    }
                    catch (DatabaseException e) {
                        Throwable cause = e.getCause();
                        if (cause != null && cause.getClass() == Replica.ConnectRetryException.class) {
                            exitException = e;
                            if (timeouts.getTimeout() > 0) {
                                LoggerUtils.warning(this.logger, this.repImpl, "Join retry due to exception: " + cause.getMessage());
                                continue;
                            }
                        }
                        throw e;
                    }
                    Object var10_15 = null;
                    this.repImpl.getStartupTracker().stop(StartupTracker.Phase.BECOME_CONSISTENT);
                    return state;
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                this.repImpl.getStartupTracker().stop(StartupTracker.Phase.BECOME_CONSISTENT);
                throw throwable;
            }
        }
        Object var10_16 = null;
        this.repImpl.getStartupTracker().stop(StartupTracker.Phase.BECOME_CONSISTENT);
        if (exitException != null) {
            LoggerUtils.warning(this.logger, this.repImpl, "Exiting joinGroup after " + retries + " retries." + exitException);
            throw exitException;
        }
        throw new UnknownMasterException(null, this.repImpl.getStateChangeEvent());
    }

    private void joinAsReplica(ReplicaConsistencyPolicy consistency) throws InterruptedException {
        if (consistency == null) {
            int consistencyTimeout = this.getConfigManager().getDuration(RepParams.ENV_CONSISTENCY_TIMEOUT);
            consistency = new PointConsistencyPolicy(new VLSN(this.replica.getMasterTxnEndVLSN()), consistencyTimeout, TimeUnit.MILLISECONDS);
        }
        consistency.ensureConsistency(this.repImpl);
        this.repImpl.getLogManager().flushNoSync();
        LoggerUtils.info(this.logger, this.repImpl, "Joined group as a replica.  join consistencyPolicy=" + consistency + " " + this.repImpl.getVLSNIndex().getRange());
    }

    public void trackSyncableVLSN(VLSN syncableVLSN, long lsn) {
        this.cbvlsnTracker.track(syncableVLSN, lsn);
    }

    public VLSN getGroupCBVLSN() {
        return this.globalCBVLSN.getCBVLSN();
    }

    public int getElectionQuorumSize(QuorumPolicy quorumPolicy) {
        if (this.electableGroupSizeOverride > 0) {
            return quorumPolicy.quorumSize(this.electableGroupSizeOverride);
        }
        if (this.activePrimary && QuorumPolicy.SIMPLE_MAJORITY.equals((Object)quorumPolicy)) {
            return 1;
        }
        return quorumPolicy.quorumSize(this.group.getElectableGroupSize());
    }

    public int minAckNodes(Durability.ReplicaAckPolicy ackPolicy) {
        if (this.electableGroupSizeOverride > 0) {
            return ackPolicy.minAckNodes(this.electableGroupSizeOverride);
        }
        if (this.activePrimary && Durability.ReplicaAckPolicy.SIMPLE_MAJORITY.equals((Object)ackPolicy)) {
            return 1;
        }
        return ackPolicy.minAckNodes(this.group.getElectableGroupSize());
    }

    public int minAckNodes(Durability durability) {
        return this.minAckNodes(durability.getReplicaAck());
    }

    public void syncupStarted() {
        this.globalCBVLSN.syncupStarted();
    }

    public void syncupEnded() {
        this.globalCBVLSN.syncupEnded();
    }

    public long getCleanerBarrierFile() throws DatabaseException {
        VLSN vlsn;
        long syncStart = this.repImpl.getSyncCleanerBarrier().getMinSyncStart();
        if (syncStart != 0L && (vlsn = new VLSN(syncStart)).compareTo(this.globalCBVLSN.getCBVLSN()) < 0) {
            return this.repImpl.getVLSNIndex().getLTEFileNumber(vlsn);
        }
        return this.globalCBVLSN.getCleanerBarrierFile();
    }

    long getReplicaCloseCatchupMs() {
        return this.replicaCloseCatchupMs;
    }

    public boolean isActivePrimary() {
        return this.activePrimary;
    }

    public boolean tryActivatePrimary() {
        boolean activatedPrimary;
        boolean bl = activatedPrimary = this.repImpl != null && this.repImpl.isDesignatedPrimary() && this.getGroup().getElectableGroupSize() == 2;
        if (activatedPrimary) {
            LoggerUtils.info(this.logger, this.repImpl, "Primary activated; quorum is one.");
            this.activePrimary = true;
        }
        return activatedPrimary;
    }

    public final void passivatePrimary() {
        if (this.activePrimary) {
            LoggerUtils.info(this.logger, this.repImpl, "Primary passivated.");
        }
        this.activePrimary = false;
    }

    public final void shutdownNetworkBackup() {
        this.logFeederManager.shutdown();
        this.logFeederManager = null;
    }

    public final void restartNetworkBackup() {
        if (this.logFeederManager != null) {
            throw EnvironmentFailureException.unexpectedState(this.repImpl);
        }
        this.logFeederManager = new com.sleepycat.je.rep.impl.networkRestore.FeederManager(this.serviceDispatcher, this.repImpl, this.nameIdPair);
    }

    public String dumpState() {
        return "\n" + this.feederManager.dumpState() + "\nGlobalCBVLSN=" + this.getGroupCBVLSN() + "\n" + this.getGroup();
    }

    public String dumpFeederState() {
        return "\n" + this.feederManager.dumpState() + "\n";
    }

    public void setElectableGroupSizeOverride(int override) {
        if (this.electableGroupSizeOverride != override) {
            LoggerUtils.warning(this.logger, this.repImpl, "Electable group size override changed to:" + override);
        }
        this.electableGroupSizeOverride = override;
    }

    public static class Clock {
        private final int skewMs;

        private Clock(int skewMs) {
            this.skewMs = skewMs;
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis() + (long)this.skewMs;
        }
    }
}

