/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.trigger.TransactionTrigger;
import com.sleepycat.je.trigger.Trigger;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerManager {
    public static void runOpenTriggers(Locker locker, Database db, boolean isNew) {
        TriggerManager.runOpenTriggers(locker, DbInternal.getDatabaseImpl(db), isNew);
    }

    public static void runOpenTriggers(Locker locker, DatabaseImpl dbImpl, final boolean isNew) {
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(isNew){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                Environment env = TriggerManager.getOpenTriggerEnvironment(triggerTransaction);
                dbt.open(triggerTransaction, env, isNew);
            }
        });
    }

    private static Environment getOpenTriggerEnvironment(Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        EnvironmentImpl envImpl = DbInternal.getTxn(transaction).getEnvironmentImpl();
        if (envImpl.isReplicated()) {
            return envImpl.getInternalEnvHandle();
        }
        return DbInternal.getEnvironment(transaction);
    }

    public static void runCloseTriggers(Locker locker, DatabaseImpl dbImpl) {
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(false){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.close();
            }
        });
    }

    public static void runRemoveTriggers(Locker locker, DatabaseImpl dbImpl) {
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.remove(triggerTransaction);
            }
        });
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.removeTrigger(triggerTransaction);
            }
        });
    }

    public static void runTruncateTriggers(Locker locker, final DatabaseImpl newDb) {
        TriggerManager.runTriggers(newDb, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.truncate(triggerTransaction);
                dbt.setDatabaseName(newDb.getName());
            }
        });
    }

    public static void runRenameTriggers(Locker locker, DatabaseImpl dbImpl, final String newName) {
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.rename(triggerTransaction, newName);
                dbt.setDatabaseName(newName);
            }
        });
    }

    public static void runCommitTriggers(Txn txn) {
        assert (txn != null);
        Set<DatabaseImpl> triggerDbs = txn.getTriggerDbs();
        if (triggerDbs == null) {
            return;
        }
        for (DatabaseImpl dbImpl : triggerDbs) {
            TriggerManager.runTriggers(dbImpl, txn, new TriggerInvoker(false){

                public void run(Transaction triggerTransaction, Trigger dbt) {
                    if (dbt instanceof TransactionTrigger) {
                        ((TransactionTrigger)((Object)dbt)).commit(triggerTransaction);
                    }
                }
            });
        }
    }

    public static void runAbortTriggers(Txn txn) {
        assert (txn != null);
        Set<DatabaseImpl> triggerDbs = txn.getTriggerDbs();
        if (triggerDbs == null) {
            return;
        }
        for (final DatabaseImpl dbImpl : triggerDbs) {
            TriggerManager.runTriggers(dbImpl, txn, new TriggerInvoker(false){

                public void run(Transaction triggerTransaction, Trigger dbt) {
                    if (dbt instanceof TransactionTrigger) {
                        ((TransactionTrigger)((Object)dbt)).abort(triggerTransaction);
                        if (!dbImpl.getName().equals(dbt.getDatabaseName())) {
                            dbt.setDatabaseName(dbImpl.getName());
                        }
                    }
                }
            });
        }
    }

    public static void runPutTriggers(Locker locker, DatabaseImpl dbImpl, final DatabaseEntry key, final DatabaseEntry oldData, final DatabaseEntry newData) {
        assert (key != null);
        assert (newData != null);
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.put(triggerTransaction, key, oldData, newData);
            }
        });
    }

    public static void runDeleteTriggers(Locker locker, DatabaseImpl dbImpl, final DatabaseEntry key, final DatabaseEntry oldData) {
        assert (key != null);
        TriggerManager.runTriggers(dbImpl, locker, new TriggerInvoker(true){

            public void run(Transaction triggerTransaction, Trigger dbt) {
                dbt.delete(triggerTransaction, key, oldData);
            }
        });
    }

    private static void runTriggers(DatabaseImpl dbImpl, Locker locker, TriggerInvoker invoker) {
        List<Trigger> triggers = dbImpl.getTriggers();
        if (triggers == null) {
            return;
        }
        Transaction triggerTransaction = locker instanceof Txn ? ((Txn)locker).getTransaction() : null;
        try {
            Iterator<Trigger> i$ = triggers.iterator();
            while (i$.hasNext()) {
                Trigger trigger;
                Trigger dbt = trigger = i$.next();
                invoker.run(triggerTransaction, dbt);
            }
        }
        catch (Exception e) {
            EnvironmentImpl env = dbImpl.getDbEnvironment();
            throw EnvironmentFailureException.unexpectedException(env, e);
        }
        if (invoker.invokeTransactionTrigger()) {
            DbInternal.getTxn(triggerTransaction).noteTriggerDb(dbImpl);
        }
    }

    public static void invokeAddremoveTriggers(Locker locker, List<Trigger> oldTriggers, List<Trigger> newTriggers) {
        Transaction txn;
        Set oldNames = new MapOver<String, Trigger>(oldTriggers){

            @Override
            protected String fun(Trigger e) {
                return e.getName();
            }
        }.run(new HashSet());
        Set newNames = new MapOver<String, Trigger>(newTriggers){

            @Override
            protected String fun(Trigger e) {
                return e.getName();
            }
        }.run(new HashSet());
        Transaction transaction = txn = locker instanceof Txn ? ((Txn)locker).getTransaction() : null;
        if (oldTriggers != null) {
            for (Trigger trigger : oldTriggers) {
                if (newNames.contains(trigger.getName())) continue;
                trigger.removeTrigger(txn);
            }
        }
        if (newTriggers != null) {
            for (Trigger trigger : newTriggers) {
                if (oldNames.contains(trigger.getName())) continue;
                trigger.addTrigger(txn);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapOver<R, E> {
        final Collection<E> c;

        public MapOver(Collection<E> c) {
            this.c = c;
        }

        public <S extends Collection<R>> S run() {
            LinkedList l = new LinkedList();
            return (S)this.run(l);
        }

        public <S extends Collection<R>> S run(S l) {
            if (this.c == null) {
                return l;
            }
            for (E e : this.c) {
                l.add(this.fun(e));
            }
            return l;
        }

        protected abstract R fun(E var1);
    }

    private static abstract class TriggerInvoker {
        final boolean invokeTransactionTrigger;

        public TriggerInvoker(boolean invokeTransactionTrigger) {
            this.invokeTransactionTrigger = invokeTransactionTrigger;
        }

        abstract void run(Transaction var1, Trigger var2);

        boolean invokeTransactionTrigger() {
            return this.invokeTransactionTrigger;
        }
    }
}

