/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CacheModeStrategy;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbEnvState;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.NodeSequence;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.PrivateEvictor;
import com.sleepycat.je.evictor.SharedEvictor;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.SyncedLogManager;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.sync.impl.SyncCleanerBarrier;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.dupConvert.DupConvert;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.LockUpgrade;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.util.ConsoleHandler;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.util.FileHandler;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.ExceptionListenerUser;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.TracerFormatter;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentImpl
implements EnvConfigObserver {
    private static final boolean TEST_NO_LOCKING_MODE = false;
    private volatile DbEnvState envState;
    private volatile boolean closing;
    private final File envHome;
    private final AtomicInteger openCount = new AtomicInteger(0);
    private final AtomicInteger backupCount = new AtomicInteger(0);
    private boolean isTransactional;
    private boolean isNoLocking;
    private boolean isReadOnly;
    private boolean isMemOnly;
    private boolean sharedCache;
    private static boolean useSharedLatchesForINs;
    private boolean dbEviction;
    private CacheMode cacheMode;
    private CacheModeStrategy cacheModeStrategy;
    private boolean initializedSuccessfully = false;
    protected boolean needRepConvert = false;
    private MemoryBudget memoryBudget;
    private static int adler32ChunkSize;
    private long lockTimeout;
    private long txnTimeout;
    protected DbTree dbMapTree;
    private long mapTreeRootLsn = -1L;
    private Latch mapTreeRootLatch;
    private INList inMemoryINs;
    protected DbConfigManager configManager;
    private List<EnvConfigObserver> configObservers;
    protected Logger envLogger;
    private com.sleepycat.je.log.LogManager logManager;
    private FileManager fileManager;
    private TxnManager txnManager;
    private Evictor evictor;
    private INCompressor inCompressor;
    private Checkpointer checkpointer;
    private Cleaner cleaner;
    private RecoveryInfo lastRecoveryInfo;
    protected final StartupTracker startupTracker;
    private EnvironmentFailureException savedInvalidatingException;
    private TestHook<Long> cleanerBarrierHoook;
    private static boolean forcedYield;
    private SharedLatch triggerLatch;
    private ExceptionListener exceptionListener = null;
    private ProgressListener<RecoveryProgress> recoveryProgressListener = null;
    private ClassLoader classLoader = null;
    private final Set<ExceptionListenerUser> exceptionListenerUsers;
    private volatile int backgroundSleepBacklog;
    private volatile int backgroundReadLimit;
    private volatile int backgroundWriteLimit;
    private long backgroundSleepInterval;
    private int backgroundReadCount;
    private long backgroundWriteBytes;
    private TestHook<?> backgroundSleepHook;
    private final Object backgroundTrackingMutex = new Object();
    private final Object backgroundSleepMutex = new Object();
    private static int threadLocalReferenceCount;
    private boolean noComparators = false;
    public final EnvironmentFailureException SAVED_EFE = EnvironmentFailureException.makeJavaErrorWrapper();
    public static final boolean USE_JAVA5_ADLER32;
    private static final String DISABLE_JAVA_ADLER32_NAME = "je.disable.java.adler32";
    private static final String REGISTER_MONITOR = "JEMonitor";
    private volatile boolean isMBeanRegistered = false;
    private static final String INFO_FILES = "je.info";
    private static final int FILEHANDLER_LIMIT = 10000000;
    private static final int FILEHANDLER_COUNT = 10;
    private final java.util.logging.ConsoleHandler consoleHandler;
    private final java.util.logging.FileHandler fileHandler;
    private final Handler configuredHandler;
    private boolean dbLoggingDisabled;
    protected final Formatter formatter;
    protected Environment envInternal;
    private final ArrayList<MBeanRegistrar> mBeanRegList = new ArrayList();
    public static final boolean IS_DALVIK;
    private final NodeSequence nodeSequence;
    private StatGroup stats;
    private LongStat relatchesRequired;
    private final String nodeName;
    private SyncCleanerBarrier syncCleanerBarrier;
    private int compactMaxKeyLength;
    private static final HaltPreloadException TIME_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException USER_HALT_REQUEST_PRELOAD_EXCEPTION;

    public EnvironmentImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv) throws EnvironmentNotFoundException, EnvironmentLockedException {
        this(envHome, envConfig, sharedCacheEnv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EnvironmentImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        boolean success = false;
        this.startupTracker = new StartupTracker(this);
        this.startupTracker.start(StartupTracker.Phase.TOTAL_ENV_OPEN);
        try {
            this.envHome = envHome;
            this.envState = DbEnvState.INIT;
            this.mapTreeRootLatch = new Latch("MapTreeRoot");
            this.exceptionListenerUsers = Collections.synchronizedSet(new HashSet());
            this.stats = new StatGroup("Environment", "General environment wide statistics.");
            this.relatchesRequired = new LongStat(this.stats, DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED);
            this.configManager = this.initConfigManager(envConfig, repConfigProxy);
            this.configObservers = new ArrayList<EnvConfigObserver>();
            this.addConfigObserver(this);
            this.initConfigParams(envConfig, repConfigProxy);
            this.formatter = this.initFormatter();
            this.consoleHandler = new ConsoleHandler(this.formatter, this);
            this.fileHandler = this.initFileHandler();
            this.configuredHandler = envConfig.getLoggingHandler();
            this.envLogger = LoggerUtils.getLogger(this.getClass());
            this.memoryBudget = new MemoryBudget(this, sharedCacheEnv, this.configManager);
            this.fileManager = new FileManager(this, envHome, this.isReadOnly);
            if (!envConfig.getAllowCreate() && !this.fileManager.filesExist()) {
                throw new EnvironmentNotFoundException(this, "Home directory: " + envHome);
            }
            this.nodeName = envConfig.getNodeName();
            this.logManager = new SyncedLogManager(this, this.isReadOnly);
            this.inMemoryINs = new INList(this);
            this.txnManager = new TxnManager(this);
            this.createDaemons(sharedCacheEnv);
            this.nodeSequence = new NodeSequence(this);
            this.dbMapTree = new DbTree(this, this.isReplicated(), this.getPreserveVLSN());
            this.triggerLatch = new SharedLatch("TriggerLatch");
            this.nodeSequence.initRealNodeId();
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (success) throw throwable;
            this.clearFileManager();
            this.closeHandlers();
            throw throwable;
        }
    }

    protected DbConfigManager initConfigManager(EnvironmentConfig envConfig, RepConfigProxy repParams) {
        return new DbConfigManager(envConfig);
    }

    protected void initConfigParams(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        forcedYield = this.configManager.getBoolean(EnvironmentParams.ENV_FORCED_YIELD);
        this.isTransactional = this.configManager.getBoolean(EnvironmentParams.ENV_INIT_TXN);
        boolean bl = this.isNoLocking = !this.configManager.getBoolean(EnvironmentParams.ENV_INIT_LOCKING);
        if (this.isTransactional && this.isNoLocking) {
            throw new IllegalArgumentException("Can't set 'je.env.isNoLocking' and 'je.env.isTransactional';");
        }
        this.isReadOnly = this.configManager.getBoolean(EnvironmentParams.ENV_RDONLY);
        this.isMemOnly = this.configManager.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY);
        useSharedLatchesForINs = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_LATCHES);
        this.dbEviction = this.configManager.getBoolean(EnvironmentParams.ENV_DB_EVICTION);
        adler32ChunkSize = this.configManager.getInt(EnvironmentParams.ADLER32_CHUNK_SIZE);
        this.sharedCache = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_CACHE);
        this.dbLoggingDisabled = !this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_DBLOG);
        this.compactMaxKeyLength = this.configManager.getInt(EnvironmentParams.TREE_COMPACT_MAX_KEY_LENGTH);
        this.recoveryProgressListener = envConfig.getRecoveryProgressListener();
        this.classLoader = envConfig.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean finishInit(EnvironmentConfig envConfig) throws DatabaseException {
        boolean bl;
        block14: {
            if (this.initializedSuccessfully) {
                return false;
            }
            boolean success = false;
            try {
                boolean doRecovery = this.configManager.getBoolean(EnvironmentParams.ENV_RECOVERY);
                if (doRecovery) {
                    try {
                        RecoveryManager recoveryManager = new RecoveryManager(this);
                        this.lastRecoveryInfo = recoveryManager.recover(this.isReadOnly);
                        this.postRecoveryConversion();
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            this.logManager.flush();
                            this.fileManager.clear();
                        }
                        catch (IOException e) {
                            throw new EnvironmentFailureException(this, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        this.logManager.flush();
                        this.fileManager.clear();
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
                    }
                }
                this.isReadOnly = true;
                if (!this.configManager.getBoolean(EnvironmentParams.ENV_COMPARATORS_REQUIRED)) {
                    this.noComparators = true;
                }
                this.lockTimeout = this.configManager.getDuration(EnvironmentParams.LOCK_TIMEOUT);
                this.txnTimeout = this.configManager.getDuration(EnvironmentParams.TXN_TIMEOUT);
                this.memoryBudget.initCacheMemoryUsage(this.dbMapTree.getTreeAdminMemory());
                this.envConfigUpdate(this.configManager, envConfig);
                this.open();
                this.initializedSuccessfully = true;
                if (doRecovery) {
                    this.convertDupDatabases();
                    this.envInternal = this.createInternalEnvironment();
                    this.syncCleanerBarrier = new SyncCleanerBarrier(this);
                    this.syncCleanerBarrier.init(this.envInternal);
                }
                this.runOrPauseDaemons(this.configManager);
                success = true;
                bl = true;
                Object var9_12 = null;
                if (success || !this.sharedCache || this.evictor == null) break block14;
            }
            catch (RuntimeException e) {
                try {
                    this.clearFileManager();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (!success && this.sharedCache && this.evictor != null) {
                        this.evictor.removeEnvironment(this);
                    }
                    this.startupTracker.stop(StartupTracker.Phase.TOTAL_ENV_OPEN);
                    this.startupTracker.setProgress(RecoveryProgress.RECOVERY_FINISHED);
                    throw throwable;
                }
            }
            this.evictor.removeEnvironment(this);
        }
        this.startupTracker.stop(StartupTracker.Phase.TOTAL_ENV_OPEN);
        this.startupTracker.setProgress(RecoveryProgress.RECOVERY_FINISHED);
        return bl;
    }

    protected Environment createInternalEnvironment() {
        return new InternalEnvironment(this.getEnvironmentHome(), this.cloneConfig(), this);
    }

    public synchronized void registerMBean(Environment env) throws DatabaseException {
        if (!this.isMBeanRegistered) {
            if (System.getProperty(REGISTER_MONITOR) != null) {
                this.doRegisterMBean(this.getMonitorClassName(), env);
                this.doRegisterMBean(this.getDiagnosticsClassName(), env);
            }
            this.isMBeanRegistered = true;
        }
    }

    protected String getMonitorClassName() {
        return "com.sleepycat.je.jmx.JEMonitor";
    }

    protected String getDiagnosticsClassName() {
        return "com.sleepycat.je.jmx.JEDiagnostics";
    }

    public ReplicaConsistencyPolicy getDefaultConsistencyPolicy() {
        return null;
    }

    public VLSN getGroupDurableVLSN() {
        throw new UnsupportedOperationException("Standalone Environment doesn't support returning GlobalDurableVLSN.");
    }

    public long getLsnForVLSN(VLSN vlsn, int readBufferSize) {
        throw new UnsupportedOperationException("Standalone Environment doesn't support finding LSN for VLSN.");
    }

    public void freezeLocalCBVLSN() {
        throw new UnsupportedOperationException("Standalone Environment doesn't support LocalCBVLSN.");
    }

    public void unfreezeLocalCBVLSN() {
        throw new UnsupportedOperationException("Standalone Environment doesn't support LocalCBVLSN.");
    }

    public long getEndOfLog() {
        return this.fileManager.getLastUsedLsn();
    }

    public SyncCleanerBarrier getSyncCleanerBarrier() {
        return this.syncCleanerBarrier;
    }

    private void doRegisterMBean(String className, Environment env) throws DatabaseException {
        try {
            Class<?> newClass = Class.forName(className);
            MBeanRegistrar mBeanReg = (MBeanRegistrar)newClass.newInstance();
            mBeanReg.doRegister(env);
            this.mBeanRegList.add(mBeanReg);
        }
        catch (Exception e) {
            throw new EnvironmentFailureException(DbInternal.getEnvironmentImpl(env), EnvironmentFailureReason.MONITOR_REGISTRATION, (Throwable)e);
        }
    }

    private synchronized void unregisterMBean() throws Exception {
        for (MBeanRegistrar mBeanReg : this.mBeanRegList) {
            mBeanReg.doUnregister();
        }
    }

    private void clearFileManager() throws DatabaseException {
        if (this.fileManager != null) {
            try {
                this.fileManager.clear();
            }
            catch (IOException IOE) {
                // empty catch block
            }
            try {
                this.fileManager.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void envConfigUpdate(DbConfigManager mgr, EnvironmentMutableConfig newConfig) {
        this.backgroundReadLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_READ_LIMIT);
        this.backgroundWriteLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_WRITE_LIMIT);
        this.backgroundSleepInterval = mgr.getDuration(EnvironmentParams.ENV_BACKGROUND_SLEEP_INTERVAL);
        if (newConfig.isConfigParamSet("com.sleepycat.je.util.ConsoleHandler.level")) {
            Level newConsoleHandlerLevel = Level.parse(mgr.get(EnvironmentParams.JE_CONSOLE_LEVEL));
            this.consoleHandler.setLevel(newConsoleHandlerLevel);
        }
        if (newConfig.isConfigParamSet("com.sleepycat.je.util.FileHandler.level")) {
            Level newFileHandlerLevel = Level.parse(mgr.get(EnvironmentParams.JE_FILE_LEVEL));
            if (this.fileHandler != null) {
                this.fileHandler.setLevel(newFileHandlerLevel);
            }
        }
        this.exceptionListener = newConfig.getExceptionListener();
        for (ExceptionListenerUser u : this.exceptionListenerUsers) {
            u.setExceptionListener(this.exceptionListener);
        }
        this.cacheMode = newConfig.getCacheMode();
        this.cacheModeStrategy = newConfig.getCacheModeStrategy();
        if (this.isValid()) {
            this.runOrPauseDaemons(mgr);
        }
    }

    public void registerExceptionListenerUser(ExceptionListenerUser u) {
        this.exceptionListenerUsers.add(u);
    }

    public boolean unregisterExceptionListenerUser(ExceptionListenerUser u) {
        return this.exceptionListenerUsers.remove(u);
    }

    private void createDaemons(EnvironmentImpl sharedCacheEnv) throws DatabaseException {
        if (sharedCacheEnv != null) {
            assert (this.sharedCache);
            this.evictor = sharedCacheEnv.evictor;
        } else {
            this.evictor = this.sharedCache ? new SharedEvictor(this) : new PrivateEvictor(this);
        }
        long checkpointerWakeupTime = Checkpointer.getWakeupPeriod(this.configManager);
        this.checkpointer = new Checkpointer(this, checkpointerWakeupTime, "Checkpointer");
        long compressorWakeupInterval = this.configManager.getDuration(EnvironmentParams.COMPRESSOR_WAKEUP_INTERVAL);
        this.inCompressor = new INCompressor(this, compressorWakeupInterval, "INCompressor");
        this.cleaner = new Cleaner(this, "Cleaner");
    }

    private void runOrPauseDaemons(DbConfigManager mgr) {
        if (!this.isReadOnly) {
            this.inCompressor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_INCOMPRESSOR));
            this.cleaner.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CLEANER) && !this.isMemOnly);
            this.checkpointer.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CHECKPOINTER));
        }
    }

    public INCompressor getINCompressor() {
        return this.inCompressor;
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.cleaner.getUtilizationTracker();
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.cleaner.getUtilizationProfile();
    }

    public CacheMode getDefaultCacheMode() {
        if (this.cacheMode != null) {
            return this.cacheMode;
        }
        return CacheMode.DEFAULT;
    }

    public CacheModeStrategy getDefaultCacheModeStrategy() {
        return this.cacheModeStrategy;
    }

    public int getCompactMaxKeyLength() {
        return this.compactMaxKeyLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundReads(int nReads) {
        int limit = this.backgroundReadLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundReadCount += nReads;
                if (this.backgroundReadCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundReadCount -= limit;
                    assert (this.backgroundReadCount >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundWrites(int writeSize, int logBufferSize) {
        int limit = this.backgroundWriteLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundWriteBytes += (long)writeSize;
                int writeCount = (int)(this.backgroundWriteBytes / (long)logBufferSize);
                if (writeCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundWriteBytes -= (long)(limit * logBufferSize);
                    assert (this.backgroundWriteBytes >= 0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleepAfterBackgroundIO() {
        if (this.backgroundSleepBacklog > 0) {
            Object object = this.backgroundSleepMutex;
            synchronized (object) {
                try {
                    Thread.sleep(this.backgroundSleepInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                assert (TestHookExecute.doHookIfSet(this.backgroundSleepHook));
            }
            object = this.backgroundTrackingMutex;
            synchronized (object) {
                if (this.backgroundSleepBacklog > 0) {
                    --this.backgroundSleepBacklog;
                }
            }
        }
    }

    public void setBackgroundSleepHook(TestHook<?> hook) {
        this.backgroundSleepHook = hook;
    }

    public void setCleanerBarrierHook(TestHook<Long> hook) {
        this.cleanerBarrierHoook = hook;
    }

    public void logMapTreeRoot() throws DatabaseException {
        this.logMapTreeRoot(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMapTreeRoot(long ifBeforeLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (ifBeforeLsn == -1L || DbLsn.compareTo(this.mapTreeRootLsn, ifBeforeLsn) < 0) {
                this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_DBTREE, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
            Object var4_2 = null;
            this.mapTreeRootLatch.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mapTreeRootLatch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteMapTreeRoot(long cleanerTargetLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (DbLsn.compareTo(cleanerTargetLsn, this.mapTreeRootLsn) == 0) {
                this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_DBTREE, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
            Object var4_2 = null;
            this.mapTreeRootLatch.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mapTreeRootLatch.release();
            throw throwable;
        }
    }

    public long getRootLsn() {
        return this.mapTreeRootLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMapTreeFromLog(long rootLsn) throws DatabaseException {
        if (this.dbMapTree != null) {
            this.dbMapTree.close();
        }
        this.dbMapTree = (DbTree)this.logManager.getEntryHandleFileNotFound(rootLsn);
        if (!this.dbMapTree.isReplicated() && this.getAllowRepConvert()) {
            this.dbMapTree.setIsReplicated();
            this.dbMapTree.setIsRepConverted();
            this.needRepConvert = true;
        }
        this.dbMapTree.initExistingEnvironment(this);
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = rootLsn;
            Object var4_2 = null;
            this.mapTreeRootLatch.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mapTreeRootLatch.release();
            throw throwable;
        }
    }

    public void addToCompressorQueue(BIN bin, boolean doWakeup) {
        if (this.inCompressor != null) {
            this.inCompressor.addBinToQueue(bin, doWakeup);
        }
    }

    public void addToCompressorQueue(BINReference binRef, boolean doWakeup) {
        if (this.inCompressor != null) {
            this.inCompressor.addBinRefToQueue(binRef, doWakeup);
        }
    }

    public void addToCompressorQueue(Collection<BINReference> binRefs, boolean doWakeup) {
        if (this.inCompressor != null) {
            this.inCompressor.addMultipleBinRefsToQueue(binRefs, doWakeup);
        }
    }

    public void lazyCompress(IN in) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.lazyCompress(in);
        }
    }

    public void resetLoggingLevel(String changedLoggerName, Level level) {
        LogManager loggerManager = LogManager.getLogManager();
        Enumeration<String> loggers = loggerManager.getLoggerNames();
        boolean validName = false;
        while (loggers.hasMoreElements()) {
            String loggerName = loggers.nextElement();
            Logger logger = loggerManager.getLogger(loggerName);
            if (!"all".equals(changedLoggerName) && !loggerName.endsWith(changedLoggerName) && !loggerName.endsWith(changedLoggerName + ".noEnv") && !loggerName.endsWith(changedLoggerName + ".fixedPrefix") && !loggerName.startsWith(changedLoggerName)) continue;
            logger.setLevel(level);
            validName = true;
        }
        if (!validName) {
            throw new IllegalArgumentException("The logger name parameter: " + changedLoggerName + " is invalid!");
        }
    }

    protected Formatter initFormatter() {
        return new TracerFormatter(this.getName());
    }

    private java.util.logging.FileHandler initFileHandler() throws DatabaseException {
        if (this.envHome == null || !this.envHome.isDirectory() || this.isReadOnly) {
            return null;
        }
        String handlerName = FileHandler.class.getName();
        String logFilePattern = this.envHome + "/" + INFO_FILES;
        int limit = 10000000;
        String logLimit = LoggerUtils.getLoggerProperty(handlerName + ".limit");
        if (logLimit != null) {
            limit = Integer.parseInt(logLimit);
        }
        int count = 10;
        String logCount = LoggerUtils.getLoggerProperty(handlerName + ".count");
        if (logCount != null) {
            count = Integer.parseInt(logCount);
        }
        try {
            return new FileHandler(logFilePattern, limit, count, this.formatter, this);
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException("Problem creating output files in: " + logFilePattern, (Exception)e);
        }
    }

    public java.util.logging.ConsoleHandler getConsoleHandler() {
        return this.consoleHandler;
    }

    public java.util.logging.FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public Handler getConfiguredHandler() {
        return this.configuredHandler;
    }

    private void closeHandlers() {
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
        }
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }

    public void open() {
        this.envState = DbEnvState.OPEN;
    }

    public void invalidate(EnvironmentFailureException e) {
        this.savedInvalidatingException = e;
        this.envState = DbEnvState.INVALID;
        this.requestShutdownDaemons();
    }

    public void invalidate(Error e) {
        if (this.SAVED_EFE.getCause() == null) {
            this.SAVED_EFE.initCause(e);
            this.invalidate(this.SAVED_EFE);
        }
    }

    public boolean isInvalid() {
        return this.savedInvalidatingException != null;
    }

    public boolean isValid() {
        return this.envState == DbEnvState.OPEN;
    }

    public boolean isInInit() {
        return this.envState == DbEnvState.INIT;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isClosed() {
        return this.envState == DbEnvState.CLOSED;
    }

    public boolean mayNotWrite() {
        return this.envState == DbEnvState.INVALID || this.envState == DbEnvState.CLOSED;
    }

    public void checkIfInvalid() throws EnvironmentFailureException {
        if (this.envState == DbEnvState.INVALID) {
            this.savedInvalidatingException.setAlreadyThrown(true);
            if (this.savedInvalidatingException == this.SAVED_EFE) {
                this.savedInvalidatingException.fillInStackTrace();
                throw this.savedInvalidatingException;
            }
            throw this.savedInvalidatingException.wrapSelf("Environment must be closed, caused by: " + this.savedInvalidatingException);
        }
    }

    public void checkNotClosed() throws DatabaseException {
        if (this.envState == DbEnvState.CLOSED) {
            throw new IllegalStateException("Attempt to use a Environment that has been closed.");
        }
    }

    public void close() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironment(this, true, false);
    }

    public void close(boolean doCheckpoint) throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironment(this, doCheckpoint, false);
    }

    public void abnormalClose() throws DatabaseException {
        this.closeInternalEnvHandle(true);
        int openCount1 = this.getOpenCount();
        if (openCount1 > 1) {
            throw EnvironmentFailureException.unexpectedState(this, "Abnormal close assumes that the open count on this handle is 1, not " + openCount1);
        }
        int backupCount1 = this.getBackupCount();
        if (backupCount1 > 0) {
            throw EnvironmentFailureException.unexpectedState(this, "Abnormal close assumes that the backup count on this handle is 0, not " + backupCount1);
        }
        DbEnvPool.getInstance().closeEnvironment(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doClose(boolean doCheckpoint, boolean isAbnormalClose) {
        this.closeInternalEnvHandle(isAbnormalClose);
        StringWriter errorStringWriter = new StringWriter();
        PrintWriter errors = new PrintWriter(errorStringWriter);
        try {
            Trace.traceLazily(this, "Close of environment " + this.envHome + " started");
            LoggerUtils.fine(this.envLogger, this, "Close of environment " + this.envHome + " started");
            this.envState.checkState(DbEnvState.VALID_FOR_CLOSE, DbEnvState.CLOSED);
            this.setupClose(errors);
            if (this.getBackupCount() > 0) {
                errors.append("\nThere are backups in progress so the ");
                errors.append("Environment can not be closed.");
                errors.println();
            }
            this.requestShutdownDaemons();
            try {
                this.unregisterMBean();
            }
            catch (Exception e) {
                errors.append("\nException unregistering MBean: ");
                e.printStackTrace(errors);
                errors.println();
            }
            boolean checkpointHappened = false;
            if (doCheckpoint && !this.isReadOnly && this.envState != DbEnvState.INVALID && this.logManager.getLastLsnAtRecovery() != this.fileManager.getLastUsedLsn()) {
                CheckpointConfig ckptConfig = new CheckpointConfig();
                ckptConfig.setForce(true);
                ckptConfig.setMinimizeRecoveryTime(true);
                try {
                    this.invokeCheckpoint(ckptConfig, "close");
                }
                catch (DatabaseException e) {
                    errors.append("\nException performing checkpoint: ");
                    e.printStackTrace(errors);
                    errors.println();
                }
                checkpointHappened = true;
            }
            this.postCheckpointClose(checkpointHappened);
            LoggerUtils.fine(this.envLogger, this, "About to shutdown daemons for Env " + this.envHome);
            this.shutdownDaemons();
            if (!isAbnormalClose) {
                try {
                    this.logManager.flush();
                }
                catch (Exception e) {
                    errors.append("\nException flushing log manager: ");
                    e.printStackTrace(errors);
                    errors.println();
                }
            }
            try {
                this.fileManager.clear();
            }
            catch (Exception e) {
                errors.append("\nException clearing file manager: ");
                e.printStackTrace(errors);
                errors.println();
            }
            try {
                this.fileManager.close();
            }
            catch (Exception e) {
                errors.append("\nException closing file manager: ");
                e.printStackTrace(errors);
                errors.println();
            }
            this.dbMapTree.close();
            this.cleaner.close();
            this.inMemoryINs.clear();
            this.closeHandlers();
            if (!isAbnormalClose && this.envState != DbEnvState.INVALID) {
                try {
                    this.checkLeaks();
                }
                catch (Exception e) {
                    errors.append("\nException performing validity checks: ");
                    e.printStackTrace(errors);
                    errors.println();
                }
            }
            Object var9_13 = null;
            this.envState = DbEnvState.CLOSED;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.envState = DbEnvState.CLOSED;
            throw throwable;
        }
        if (errorStringWriter.getBuffer().length() > 0 && this.savedInvalidatingException == null) {
            throw EnvironmentFailureException.unexpectedState(errorStringWriter.toString());
        }
    }

    protected synchronized void setupClose(PrintWriter errors) throws DatabaseException {
    }

    protected synchronized void postCheckpointClose(boolean checkpointed) throws DatabaseException {
    }

    protected void postRecoveryConversion() {
    }

    private void convertDupDatabases() {
        if (this.dbMapTree.getDupsConverted()) {
            return;
        }
        DupConvert dupConvert = new DupConvert(this, this.dbMapTree);
        dupConvert.convertDatabases();
        this.dbMapTree.setDupsConverted();
        this.logMapTreeRoot();
        this.logManager.flush();
    }

    public void closeAfterInvalid() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironmentAfterInvalid(this);
    }

    public synchronized void doCloseAfterInvalid() {
        try {
            this.unregisterMBean();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.shutdownDaemons();
        try {
            this.fileManager.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeHandlers();
    }

    void incOpenCount() {
        this.openCount.incrementAndGet();
    }

    boolean decOpenCount() {
        return this.openCount.decrementAndGet() <= 0;
    }

    private int getOpenCount() {
        return this.openCount.get();
    }

    protected int getAppOpenCount() {
        return this.openCount.get();
    }

    void incBackupCount() {
        this.backupCount.incrementAndGet();
    }

    void decBackupCount() {
        this.backupCount.decrementAndGet();
    }

    protected int getBackupCount() {
        return this.backupCount.get();
    }

    public static int getThreadLocalReferenceCount() {
        return threadLocalReferenceCount;
    }

    static synchronized void incThreadLocalReferenceCount() {
        ++threadLocalReferenceCount;
    }

    static synchronized void decThreadLocalReferenceCount() {
        --threadLocalReferenceCount;
    }

    public boolean getNoComparators() {
        return this.noComparators;
    }

    private void checkLeaks() throws DatabaseException {
        long memoryUsage;
        TransactionStats txnStat;
        if (!this.configManager.getBoolean(EnvironmentParams.ENV_CHECK_LEAKS)) {
            return;
        }
        boolean clean = true;
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setFast(false);
        LockStats lockStat = this.lockStat(statsConfig);
        if (lockStat.getNTotalLocks() != 0) {
            clean = false;
            System.err.println("Problem: " + lockStat.getNTotalLocks() + " locks left");
            this.txnManager.getLockManager().dump();
        }
        if ((txnStat = this.txnStat(statsConfig)).getNActive() != 0) {
            clean = false;
            System.err.println("Problem: " + txnStat.getNActive() + " txns left");
            TransactionStats.Active[] active = txnStat.getActiveTxns();
            if (active != null) {
                for (TransactionStats.Active element : active) {
                    System.err.println(element);
                }
            }
        }
        if (LatchSupport.countLatchesHeld() > 0) {
            clean = false;
            System.err.println("Some latches held at env close.");
            LatchSupport.dumpLatchesHeld();
        }
        if ((memoryUsage = this.memoryBudget.getVariableCacheUsage()) != 0L) {
            clean = false;
            System.err.println("Local Cache Usage = " + memoryUsage);
            System.err.println(this.memoryBudget.loadStats());
        }
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!clean && assertionsEnabled) {
            throw EnvironmentFailureException.unexpectedState("Lock, transaction, latch or memory left behind at environment close");
        }
    }

    public boolean invokeCheckpoint(CheckpointConfig config, String invokingSource) throws DatabaseException {
        if (this.checkpointer != null) {
            this.checkpointer.doCheckpoint(config, invokingSource);
            return true;
        }
        return false;
    }

    public void flushLog(boolean fsync) {
        if (fsync) {
            this.logManager.flush();
        } else {
            this.logManager.flushWriteNoSync();
        }
    }

    public long forceLogFileFlip() throws DatabaseException {
        return this.logManager.logForceFlip(new SingleItemEntry(LogEntryType.LOG_TRACE, new Trace("File Flip")));
    }

    public boolean invokeCompressor() throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.doCompress();
            return true;
        }
        return false;
    }

    public void invokeEvictor() throws DatabaseException {
        if (this.evictor != null) {
            this.evictor.doManualEvict();
        }
    }

    public int invokeCleaner() throws DatabaseException {
        if (this.isReadOnly || this.isMemOnly) {
            throw new UnsupportedOperationException("Log cleaning not allowed in a read-only or memory-only environment");
        }
        if (this.cleaner != null) {
            return this.cleaner.doClean(true, false);
        }
        return 0;
    }

    public void requestShutdownDaemons() {
        this.closing = true;
        if (this.inCompressor != null) {
            this.inCompressor.requestShutdown();
        }
        if (this.evictor != null && !this.sharedCache) {
            this.evictor.requestShutdownPool();
        }
        if (this.checkpointer != null) {
            this.checkpointer.requestShutdown();
        }
        if (this.cleaner != null) {
            this.cleaner.requestShutdown();
        }
    }

    public void stopDaemons() {
        if (this.inCompressor != null) {
            this.inCompressor.shutdown();
        }
        if (this.evictor != null) {
            this.evictor.shutdown();
        }
        if (this.checkpointer != null) {
            this.checkpointer.shutdown();
        }
        if (this.cleaner != null) {
            this.cleaner.shutdown();
        }
    }

    public void shutdownDaemons() {
        this.shutdownINCompressor();
        this.shutdownCleaner();
        this.shutdownCheckpointer();
        this.shutdownEvictor();
    }

    void shutdownINCompressor() {
        if (this.inCompressor != null) {
            this.inCompressor.shutdown();
            this.inCompressor.clearEnv();
            this.inCompressor = null;
        }
    }

    void shutdownEvictor() {
        if (this.evictor != null) {
            if (this.sharedCache) {
                this.evictor.removeEnvironment(this);
            } else {
                this.evictor.shutdown();
                this.evictor = null;
            }
        }
    }

    void shutdownCheckpointer() {
        if (this.checkpointer != null) {
            this.checkpointer.shutdown();
            this.checkpointer.clearEnv();
            this.checkpointer = null;
        }
    }

    public void shutdownCleaner() {
        if (this.cleaner != null) {
            this.cleaner.shutdown();
        }
    }

    public boolean isNoLocking() {
        return this.isNoLocking;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isMemOnly() {
        return this.isMemOnly;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public static boolean getSharedLatches() {
        return useSharedLatchesForINs;
    }

    public boolean getDbEviction() {
        return this.dbEviction;
    }

    public static int getAdler32ChunkSize() {
        return adler32ChunkSize;
    }

    public boolean getSharedCache() {
        return this.sharedCache;
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        return this.txnManager.txnBegin(parent, txnConfig);
    }

    public com.sleepycat.je.log.LogManager getLogManager() {
        return this.logManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public DbTree getDbTree() {
        return this.dbMapTree;
    }

    public DbConfigManager getConfigManager() {
        return this.configManager;
    }

    public NodeSequence getNodeSequence() {
        return this.nodeSequence;
    }

    public EnvironmentConfig cloneConfig() {
        return this.configManager.getEnvironmentConfig().clone();
    }

    public EnvironmentMutableConfig cloneMutableConfig() {
        return DbInternal.cloneMutableConfig(this.configManager.getEnvironmentConfig());
    }

    public void checkImmutablePropsForEquality(Properties handleConfigProps) throws IllegalArgumentException {
        DbInternal.checkImmutablePropsForEquality(this.configManager.getEnvironmentConfig(), handleConfigProps);
    }

    public void setMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        DbEnvPool.getInstance().setMutableConfig(this, config);
    }

    synchronized void doSetMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        EnvironmentConfig newConfig = this.configManager.getEnvironmentConfig().clone();
        DbInternal.copyMutablePropsTo(config, newConfig);
        this.configManager = this.resetConfigManager(newConfig);
        for (int i = this.configObservers.size() - 1; i >= 0; --i) {
            EnvConfigObserver o = this.configObservers.get(i);
            o.envConfigUpdate(this.configManager, newConfig);
        }
    }

    protected DbConfigManager resetConfigManager(EnvironmentConfig newConfig) {
        return new DbConfigManager(newConfig);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public synchronized void addConfigObserver(EnvConfigObserver o) {
        this.configObservers.add(o);
    }

    public synchronized void removeConfigObserver(EnvConfigObserver o) {
        this.configObservers.remove(o);
    }

    public INList getInMemoryINs() {
        return this.inMemoryINs;
    }

    public TxnManager getTxnManager() {
        return this.txnManager;
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MemoryBudget getMemoryBudget() {
        return this.memoryBudget;
    }

    public Logger getLogger() {
        return this.envLogger;
    }

    public boolean isDbLoggingDisabled() {
        return this.dbLoggingDisabled;
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        return this.dbMapTree.verify(config, out);
    }

    public void verifyCursors() throws DatabaseException {
        this.inCompressor.verifyCursors();
    }

    public synchronized EnvironmentStats loadStats(StatsConfig config) throws DatabaseException {
        EnvironmentStats envStats = new EnvironmentStats();
        envStats.setINCompStats(this.inCompressor.loadStats(config));
        envStats.setCkptStats(this.checkpointer.loadStats(config));
        envStats.setCleanerStats(this.cleaner.loadStats(config));
        envStats.setLogStats(this.logManager.loadStats(config));
        envStats.setMBAndEvictorStats(this.memoryBudget.loadStats(), this.evictor.loadStats(config));
        envStats.setLockStats(this.txnManager.loadStats(config));
        envStats.setEnvImplStats(this.loadEnvImplStats(config));
        return envStats;
    }

    public StatGroup loadEnvImplStats(StatsConfig config) {
        return this.stats.cloneGroup(config.getClear());
    }

    public void incRelatchesRequired() {
        this.relatchesRequired.increment();
    }

    public boolean addDbBackup(DbBackup backup) {
        this.incBackupCount();
        return true;
    }

    public void removeDbBackup(DbBackup backup) {
        this.decBackupCount();
    }

    public synchronized LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.lockStat(config);
    }

    public synchronized TransactionStats txnStat(StatsConfig config) {
        return this.txnManager.txnStat(config);
    }

    public int getINCompressorQueueSize() {
        return this.inCompressor.getBinRefQueueSize();
    }

    public StartupTracker getStartupTracker() {
        return this.startupTracker;
    }

    public File getEnvironmentHome() {
        return this.envHome;
    }

    public Environment getInternalEnvHandle() {
        return this.envInternal;
    }

    private synchronized void closeInternalEnvHandle(boolean isAbnormalClose) {
        if (this.envInternal == null) {
            return;
        }
        if (isAbnormalClose) {
            this.envInternal = null;
        } else {
            Environment savedEnvInternal = this.envInternal;
            this.envInternal = null;
            DbInternal.closeInternalHandle(savedEnvInternal);
        }
    }

    public String getName() {
        if (this.nodeName == null) {
            return this.envHome.toString();
        }
        return this.getNodeName();
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public long getReplayTxnTimeout() {
        if (this.lockTimeout != 0L) {
            return this.lockTimeout;
        }
        return 1L;
    }

    public SharedLatch getTriggerLatch() {
        return this.triggerLatch;
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    void alertEvictor() {
        if (this.evictor != null) {
            this.evictor.alert();
        }
    }

    public void criticalEviction(boolean backgroundIO) {
        this.evictor.doCriticalEviction(backgroundIO);
    }

    public void daemonEviction(boolean backgroundIO) {
        this.evictor.doDaemonEviction(backgroundIO);
    }

    public long specialEviction() {
        return this.cleaner.getUtilizationTracker().evictMemory();
    }

    public boolean isCacheFull() {
        return this.getEvictor().isCacheFull();
    }

    public boolean wasCacheEverFull() {
        return this.getEvictor().wasCacheEverFull();
    }

    public static boolean maybeForceYield() {
        if (forcedYield) {
            Thread.yield();
        }
        return true;
    }

    public boolean isReplicated() {
        return false;
    }

    public boolean getPreserveVLSN() {
        return false;
    }

    public boolean getCacheVLSN() {
        return false;
    }

    public int getCachedVLSNMinLength() {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public boolean getAllowRepConvert() {
        return false;
    }

    public boolean isRepConverted() {
        return this.dbMapTree.isRepConverted();
    }

    public boolean needRepConvert() {
        return this.needRepConvert;
    }

    public VLSN bumpVLSN() {
        return null;
    }

    public void decrementVLSN() {
    }

    public VLSNRecoveryProxy getVLSNProxy() throws DatabaseException {
        return new NoopVLSNProxy();
    }

    public boolean isMaster() {
        return false;
    }

    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
    }

    public void registerVLSN(LogItem logItem) {
    }

    public void vlsnHeadTruncate(VLSN lastVLSN, long deleteFileNum) {
    }

    public void preCheckpointEndFlush() throws DatabaseException {
    }

    public Txn createReplayTxn(long txnId) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public ThreadLocker createRepThreadLocker() {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public Txn createRepUserTxn(TransactionConfig config) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public Txn createRepTxn(TransactionConfig config, long mandatedId) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createLockPreemptedException(Locker locker, Throwable cause) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createDatabasePreemptedException(String msg, String dbName, Database db) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createLogOverwriteException(String msg) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public long getCleanerBarrierStartFile() {
        if (this.cleanerBarrierHoook != null) {
            return this.cleanerBarrierHoook.getHookValue();
        }
        long syncStart = this.syncCleanerBarrier.getMinSyncStart();
        return syncStart == 0L ? DbLsn.getFileNumber(this.getEndOfLog()) : DbLsn.getFileNumber(syncStart);
    }

    public void checkRulesForExistingEnv(boolean dbTreeReplicatedBit, boolean dbTreePreserveVLSN) throws UnsupportedOperationException {
        if (dbTreeReplicatedBit && !this.isReadOnly()) {
            throw new UnsupportedOperationException("This environment was previously opened for replication. It cannot be re-opened for in read/write mode for non-replicated operation.");
        }
        if (this.getPreserveVLSN() && !this.isReadOnly()) {
            throw new IllegalArgumentException("je.rep.preserveRecordVersion parameter may not be true in a read-write, non-replicated environment");
        }
    }

    public void awaitVLSNConsistency() {
    }

    public PreloadStats preload(DatabaseImpl[] dbImpls, PreloadConfig config) throws DatabaseException {
        try {
            long maxBytes = config.getMaxBytes();
            long maxMillisecs = config.getMaxMillisecs();
            long targetTime = Long.MAX_VALUE;
            if (maxMillisecs > 0L && (targetTime = System.currentTimeMillis() + maxMillisecs) < 0L) {
                targetTime = Long.MAX_VALUE;
            }
            long cacheBudget = this.getMemoryBudget().getMaxMemory();
            if (maxBytes == 0L) {
                maxBytes = cacheBudget;
            } else if (maxBytes > cacheBudget) {
                throw new IllegalArgumentException("maxBytes parameter to preload() was specified as " + maxBytes + " bytes \nbut the cache is only " + cacheBudget + " bytes.");
            }
            Arrays.sort(dbImpls, new Comparator<DatabaseImpl>(){

                @Override
                public int compare(DatabaseImpl o1, DatabaseImpl o2) {
                    DatabaseId id1 = o1.getId();
                    DatabaseId id2 = o2.getId();
                    return id1.compareTo(id2);
                }
            });
            PreloadStats pstats = new PreloadStats();
            PreloadProcessor callback = new PreloadProcessor(this, maxBytes, targetTime, pstats, config);
            int nDbs = dbImpls.length;
            long[] rootLsns = new long[nDbs];
            for (int i = 0; i < nDbs; ++i) {
                rootLsns[i] = dbImpls[i].getTree().getRootLsn();
            }
            PreloadLSNTreeWalker walker = new PreloadLSNTreeWalker(dbImpls, rootLsns, callback, config);
            try {
                ((SortedLSNTreeWalker)walker).walk();
                callback.close();
            }
            catch (HaltPreloadException HPE) {
                pstats.setStatus(HPE.getStatus());
            }
            assert (LatchSupport.countLatchesHeld() == 0);
            return pstats;
        }
        catch (Error E) {
            this.invalidate(E);
            throw E;
        }
    }

    public ProgressListener<RecoveryProgress> getRecoveryProgressListener() {
        return this.recoveryProgressListener;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static {
        forcedYield = false;
        threadLocalReferenceCount = 0;
        USE_JAVA5_ADLER32 = System.getProperty(DISABLE_JAVA_ADLER32_NAME) == null;
        IS_DALVIK = "Dalvik".equals(System.getProperty("java.vm.name"));
        LockUpgrade.ILLEGAL.setUpgrade(null);
        LockUpgrade.EXISTING.setUpgrade(null);
        LockUpgrade.WRITE_PROMOTE.setUpgrade(LockType.WRITE);
        LockUpgrade.RANGE_READ_IMMED.setUpgrade(LockType.RANGE_READ);
        LockUpgrade.RANGE_WRITE_IMMED.setUpgrade(LockType.RANGE_WRITE);
        LockUpgrade.RANGE_WRITE_PROMOTE.setUpgrade(LockType.RANGE_WRITE);
        TIME_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.EXCEEDED_TIME);
        MEMORY_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.FILLED_CACHE);
        USER_HALT_REQUEST_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.USER_HALT_REQUEST);
    }

    private class PreloadLSNTreeWalker
    extends SortedLSNTreeWalker {
        PreloadLSNTreeWalker(DatabaseImpl[] dbs, long[] rootLsns, SortedLSNTreeWalker.TreeNodeProcessor callback, PreloadConfig conf) throws DatabaseException {
            super(dbs, false, rootLsns, callback, null, null);
            this.accumulateLNs = conf.getLoadLNs();
            this.setLSNBatchSize(conf.getLSNBatchSize());
            this.setInternalMemoryLimit(conf.getInternalMemoryLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void walk() throws DatabaseException {
            int nDbs = this.dbImpls.length;
            try {
                try {
                    for (int i = 0; i < nDbs; ++i) {
                        DatabaseImpl dbImpl = this.dbImpls[i];
                        dbImpl.getTree().latchRootLatchExclusive();
                    }
                }
                catch (Exception e) {
                    throw EnvironmentFailureException.unexpectedException(EnvironmentImpl.this, "Couldn't latch all DatabaseImpls during preload", e);
                }
                this.walkInternal();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                for (int i = nDbs - 1; i >= 0; --i) {
                    DatabaseImpl dbImpl = this.dbImpls[i];
                    dbImpl.getTree().releaseRootLatch();
                }
                throw throwable;
            }
            for (int i = nDbs - 1; i >= 0; --i) {
                DatabaseImpl dbImpl = this.dbImpls[i];
                dbImpl.getTree().releaseRootLatch();
            }
        }

        protected IN getRootIN(DatabaseImpl dbImpl, long rootLsn) {
            return dbImpl.getTree().getRootIN(CacheMode.UNCHANGED);
        }

        protected boolean fetchAndInsertIntoTree() {
            return true;
        }
    }

    private static class PreloadProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final EnvironmentImpl envImpl;
        private final long maxBytes;
        private final long targetTime;
        private final PreloadStats stats;
        private final boolean countLNs;
        private final ProgressListener<PreloadConfig.Phases> progressListener;
        private long progressCounter = 0L;

        PreloadProcessor(EnvironmentImpl envImpl, long maxBytes, long targetTime, PreloadStats stats, PreloadConfig config) {
            this.envImpl = envImpl;
            this.maxBytes = maxBytes;
            this.targetTime = targetTime;
            this.stats = stats;
            this.countLNs = config.getLoadLNs();
            this.progressListener = config.getProgressListener();
        }

        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) {
            if (System.currentTimeMillis() > this.targetTime) {
                throw TIME_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (this.envImpl.getMemoryBudget().getCacheMemoryUsage() > this.maxBytes) {
                throw MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (this.progressListener != null) {
                ++this.progressCounter;
                if (!this.progressListener.progress(PreloadConfig.Phases.PRELOAD, this.progressCounter, -1L)) {
                    throw USER_HALT_REQUEST_PRELOAD_EXCEPTION;
                }
            }
            if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                this.stats.incDupCountLNsLoaded();
            } else if (childType.isLNType()) {
                if (this.countLNs) {
                    this.stats.incLNsLoaded();
                }
            } else if (childType.equals(LogEntryType.LOG_DBIN)) {
                this.stats.incDBINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_BIN)) {
                this.stats.incBINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_DIN)) {
                this.stats.incDINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_IN)) {
                this.stats.incINsLoaded();
            }
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
        }

        public void noteMemoryExceeded() {
            this.stats.incMemoryExceeded();
        }

        public void close() {
            if (this.progressListener != null) {
                this.progressListener.progress(PreloadConfig.Phases.PRELOAD, this.progressCounter, this.progressCounter);
            }
        }
    }

    private static class HaltPreloadException
    extends RuntimeException {
        private final PreloadStatus status;

        HaltPreloadException(PreloadStatus status) {
            super(status.toString());
            this.status = status;
        }

        PreloadStatus getStatus() {
            return this.status;
        }
    }

    private static class InternalEnvironment
    extends Environment {
        public InternalEnvironment(File envHome, EnvironmentConfig configuration, EnvironmentImpl envImpl) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
            super(envHome, configuration, false, null, envImpl);
        }

        protected boolean isInternalHandle() {
            return true;
        }

        public synchronized void close() {
            throw EnvironmentFailureException.unexpectedState("close() not permitted on an internal environment handle");
        }
    }

    private class NoopVLSNProxy
    implements VLSNRecoveryProxy {
        private NoopVLSNProxy() {
        }

        public void trackMapping(long lsn, LogEntryHeader currentEntryHeader, LogEntry targetLogEntry) {
        }
    }

    public static interface MBeanRegistrar {
        public void doRegister(Environment var1) throws Exception;

        public void doUnregister() throws Exception;
    }
}

