/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryIntegrityException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class JoinCursor
implements Closeable {
    private JoinConfig config;
    private Database priDb;
    private Cursor priCursor;
    private Cursor[] secCursors;
    private DatabaseEntry[] cursorScratchEntries;
    private DatabaseEntry scratchEntry;

    JoinCursor(Locker locker, Database primaryDb, final Cursor[] cursors, JoinConfig configParam) throws DatabaseException {
        this.priDb = primaryDb;
        this.config = configParam != null ? configParam.clone() : JoinConfig.DEFAULT;
        this.scratchEntry = new DatabaseEntry();
        this.cursorScratchEntries = new DatabaseEntry[cursors.length];
        Cursor[] sortedCursors = new Cursor[cursors.length];
        System.arraycopy(cursors, 0, sortedCursors, 0, cursors.length);
        if (!this.config.getNoSort()) {
            final long[] counts = new long[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                counts[i] = cursors[i].countEstimateInternal();
                assert (counts[i] >= 0L);
            }
            Arrays.sort(sortedCursors, new Comparator<Cursor>(){

                @Override
                public int compare(Cursor o1, Cursor o2) {
                    long count1 = -1L;
                    long count2 = -1L;
                    for (int i = 0; i < cursors.length && (count1 < 0L || count2 < 0L); ++i) {
                        if (cursors[i] == o1) {
                            count1 = counts[i];
                            continue;
                        }
                        if (cursors[i] != o2) continue;
                        count2 = counts[i];
                    }
                    assert (count1 >= 0L && count2 >= 0L);
                    long cmp = count1 - count2;
                    return cmp < 0L ? -1 : (cmp > 0L ? 1 : 0);
                }
            });
        }
        try {
            this.priCursor = new Cursor(this.priDb, locker, null);
            this.secCursors = new Cursor[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                this.secCursors[i] = new Cursor(sortedCursors[i], true);
            }
        }
        catch (DatabaseException e) {
            this.close(e);
        }
    }

    public void close() throws DatabaseException {
        if (this.priCursor == null) {
            return;
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        if (this.priCursor != null) {
            block7: {
                try {
                    this.priCursor.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block7;
                    firstException = e;
                }
            }
            this.priCursor = null;
        }
        for (int i = 0; i < this.secCursors.length; ++i) {
            block8: {
                if (this.secCursors[i] == null) continue;
                try {
                    this.secCursors[i].close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block8;
                    firstException = e;
                }
            }
            this.secCursors[i] = null;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    Cursor[] getSortedCursors() {
        return this.secCursors;
    }

    public Database getDatabase() {
        return this.priDb;
    }

    public JoinConfig getConfig() {
        return this.config.clone();
    }

    public OperationStatus getNext(DatabaseEntry key, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key): ", lockMode);
        return this.retrieveNext(key, null, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key,data): ", lockMode);
        return this.retrieveNext(key, data, lockMode);
    }

    private OperationStatus retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry candidateKey;
        block0: while (true) {
            Cursor secCursor = this.secCursors[0];
            candidateKey = this.cursorScratchEntries[0];
            if (candidateKey == null) {
                this.cursorScratchEntries[0] = candidateKey = new DatabaseEntry();
                status = secCursor.getCurrentInternal(this.scratchEntry, candidateKey, lockMode);
            } else {
                status = secCursor.retrieveNext(this.scratchEntry, candidateKey, lockMode, GetMode.NEXT_DUP);
            }
            if (status != OperationStatus.SUCCESS) {
                return status;
            }
            for (int i = 1; i < this.secCursors.length; ++i) {
                secCursor = this.secCursors[i];
                DatabaseEntry secKey = this.cursorScratchEntries[i];
                if (secKey == null) {
                    this.cursorScratchEntries[i] = secKey = new DatabaseEntry();
                    status = secCursor.getCurrentInternal(secKey, this.scratchEntry, lockMode);
                    assert (status == OperationStatus.SUCCESS);
                }
                this.scratchEntry.setData(secKey.getData(), secKey.getOffset(), secKey.getSize());
                status = secCursor.search(this.scratchEntry, candidateKey, lockMode, CursorImpl.SearchMode.BOTH);
                if (status != OperationStatus.SUCCESS) continue block0;
            }
            break;
        }
        if (dataParam != null && (status = this.priCursor.search(candidateKey, dataParam, lockMode, CursorImpl.SearchMode.SET)) != OperationStatus.SUCCESS) {
            Database secDb = this.secCursors[this.secCursors.length - 1].getDatabase();
            throw new SecondaryIntegrityException(this.priCursor.getCursorImpl().getLocker(), "Join secondary cursors refer to a missing key in the primary database", secDb.getDebugName(), this.scratchEntry, candidateKey);
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return OperationStatus.SUCCESS;
    }
}

