/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.blueprints;

import com.tinkerpop.blueprints.Graph;
import griffon.plugins.blueprints.BlueprintsProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlueprintsProvider
implements BlueprintsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBlueprintsProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withBlueprints(Closure<R> closure) {
        return this.withBlueprints(DEFAULT, closure);
    }

    @Override
    public <R> R withBlueprints(String graphName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)graphName)) {
            graphName = DEFAULT;
        }
        if (closure != null) {
            Graph graph = this.getGraph(graphName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on graph '" + graphName + "'");
            }
            return (R)closure.call(new Object[]{graphName, graph});
        }
        return null;
    }

    @Override
    public <R> R withBlueprints(CallableWithArgs<R> callable) {
        return this.withBlueprints(DEFAULT, callable);
    }

    @Override
    public <R> R withBlueprints(String graphName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)graphName)) {
            graphName = DEFAULT;
        }
        if (callable != null) {
            Graph graph = this.getGraph(graphName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statements on graph '" + graphName + "'");
            }
            callable.setArgs(new Object[]{graphName, graph});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract Graph getGraph(String var1);
}

