/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.activejdbc;

import griffon.plugins.activejdbc.ActivejdbcProvider;
import griffon.plugins.datasource.DataSourceHolder;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import javax.sql.DataSource;
import org.javalite.activejdbc.Base;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivejdbcProvider
implements ActivejdbcProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActivejdbcProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withActivejdbc(Closure<R> closure) {
        return this.withActivejdbc(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withActivejdbc(String dataSourceName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (closure != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on processEngine '" + dataSourceName + "'");
            }
            try {
                Base.open((DataSource)DataSourceHolder.getInstance().getDataSource(dataSourceName));
                Object object = closure.call((Object)dataSourceName);
                return (R)object;
            }
            finally {
                Base.close();
            }
        }
        return null;
    }

    @Override
    public <R> R withActivejdbc(CallableWithArgs<R> callable) {
        return this.withActivejdbc(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withActivejdbc(String dataSourceName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (callable != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on processEngine '" + dataSourceName + "'");
            }
            try {
                Base.open((DataSource)DataSourceHolder.getInstance().getDataSource(dataSourceName));
                callable.setArgs(new Object[]{dataSourceName});
                Object object = callable.call();
                return (R)object;
            }
            finally {
                Base.close();
            }
        }
        return null;
    }
}

