/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.actions;

import griffon.core.GriffonController;
import griffon.core.GriffonControllerClass;
import griffon.plugins.i18n.ConstrainedMessageSource;
import griffon.plugins.i18n.MessageSource;
import griffon.plugins.i18n.MessageSourceHolder;
import griffon.plugins.i18n.NoSuchMessageException;
import griffon.swing.SwingAction;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ActionManager.class);
    public static final String ACTION = "Action";
    private static ActionManager INSTANCE = new ActionManager();
    private Map<GriffonController, Map<String, Action>> actionCache = new LinkedHashMap<GriffonController, Map<String, Action>>();

    public static ActionManager getInstance() {
        return INSTANCE;
    }

    private ActionManager() {
    }

    public Map<String, Action> actionsFor(GriffonController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller parameter is null!");
        }
        Map<String, Action> actions = this.actionCache.get(controller);
        if (actions == null) {
            actions = Collections.emptyMap();
            if (LOG.isTraceEnabled()) {
                LOG.trace("No actions defined for controller " + controller);
            }
        }
        return actions;
    }

    public Action actionFor(GriffonController controller, String actionName) {
        if (controller == null) {
            throw new IllegalArgumentException("controller parameter is null!");
        }
        if (GriffonNameUtils.isBlank((String)actionName)) {
            throw new IllegalArgumentException("actionName parameter is null!");
        }
        return this.actionCache.get(controller).get(this.normalizeName(actionName));
    }

    public void createActions(GriffonController controller) {
        GriffonControllerClass griffonClass = (GriffonControllerClass)controller.getGriffonClass();
        for (String actionName : griffonClass.getActionNames()) {
            Action action = this.createAction(controller, actionName);
            Map<String, Action> actions = this.actionCache.get(controller);
            if (actions == null) {
                actions = new LinkedHashMap<String, Action>();
                this.actionCache.put(controller, actions);
            }
            String actionKey = this.normalizeName(actionName);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Action for " + controller.getClass().getName() + "." + actionName + " stored as " + actionKey);
            }
            actions.put(actionKey, action);
        }
    }

    public String normalizeName(String actionName) {
        if (actionName.endsWith(ACTION)) {
            actionName = actionName.substring(0, actionName.length() - ACTION.length());
        }
        return GriffonNameUtils.uncapitalize((String)actionName);
    }

    private Action createAction(GriffonController controller, String actionName) {
        String rsEnabled;
        String rsLargeIcon;
        String rsSmallIcon;
        String rsMnemonic;
        String rsLongDescription;
        String rsShortDescription;
        String rsCommand;
        String rsAccelerator;
        SwingAction.ActionBuilder builder = SwingAction.action();
        String normalizeNamed = GriffonNameUtils.capitalize((String)this.normalizeName(actionName));
        String prefix = controller.getClass().getName() + ".action.";
        String rsActionName = ActionManager.msg(controller, prefix, normalizeNamed, "name", GriffonNameUtils.getNaturalName((String)normalizeNamed));
        if (!GriffonNameUtils.isBlank((String)rsActionName)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".name = " + rsActionName);
            }
            builder.withName(rsActionName);
        }
        if (!GriffonNameUtils.isBlank((String)(rsAccelerator = ActionManager.msg(controller, prefix, normalizeNamed, "accelerator", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".accelerator = " + rsAccelerator);
            }
            builder.withAccelerator(rsAccelerator);
        }
        if (!GriffonNameUtils.isBlank((String)(rsCommand = ActionManager.msg(controller, prefix, normalizeNamed, "command", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".command = " + rsCommand);
            }
            builder.withCommand(rsCommand);
        }
        if (!GriffonNameUtils.isBlank((String)(rsShortDescription = ActionManager.msg(controller, prefix, normalizeNamed, "short_description", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".short_description = " + rsShortDescription);
            }
            builder.withShortDescription(rsShortDescription);
        }
        if (!GriffonNameUtils.isBlank((String)(rsLongDescription = ActionManager.msg(controller, prefix, normalizeNamed, "long_description", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".long_description = " + rsLongDescription);
            }
            builder.withLongDescription(rsLongDescription);
        }
        if (!GriffonNameUtils.isBlank((String)(rsMnemonic = ActionManager.msg(controller, prefix, normalizeNamed, "mnemonic", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".mnemonic = " + rsMnemonic);
            }
            builder.withMnemonic(rsMnemonic);
        }
        if (!GriffonNameUtils.isBlank((String)(rsSmallIcon = ActionManager.msg(controller, prefix, normalizeNamed, "small_icon", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".small_icon = " + rsSmallIcon);
            }
            builder.withSmallIcon((Icon)new ImageIcon(rsSmallIcon));
        }
        if (!GriffonNameUtils.isBlank((String)(rsLargeIcon = ActionManager.msg(controller, prefix, normalizeNamed, "large_icon", "")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".large_icon = " + rsLargeIcon);
            }
            builder.withLargeIcon((Icon)new ImageIcon(rsLargeIcon));
        }
        if (!GriffonNameUtils.isBlank((String)(rsEnabled = ActionManager.msg(controller, prefix, normalizeNamed, "enabled", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(prefix + normalizeNamed + ".enabled = " + rsEnabled);
            }
            builder.withEnabled(DefaultTypeTransformation.castToBoolean((Object)rsEnabled));
        }
        builder.withClosure((Closure)new MethodClosure((Object)controller, actionName));
        return builder.build();
    }

    private static String msg(GriffonController controller, String key, String actionName, String subkey, String defaultValue) {
        MessageSource msgSrc = MessageSourceHolder.getMessageSource();
        if (msgSrc instanceof ConstrainedMessageSource) {
            msgSrc = MessageSourceHolder.getMessageSource(controller.getClass());
        }
        try {
            return msgSrc.getMessage(key + actionName + "." + subkey);
        }
        catch (NoSuchMessageException nsme) {
            return msgSrc.getMessage("application.action." + actionName + "." + subkey, defaultValue);
        }
    }
}

